// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmPaloAltoNetworksNgfwModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Ngfw.GlobalRulestackData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Global Location. </param>
        /// <param name="identity"> The managed service identities assigned to this resource. </param>
        /// <param name="panETag"> PanEtag info. </param>
        /// <param name="panLocation"> Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks. </param>
        /// <param name="scope"> Rulestack Type. </param>
        /// <param name="associatedSubscriptions"> subscription scope of global rulestack. </param>
        /// <param name="description"> rulestack description. </param>
        /// <param name="defaultMode"> Mode for default rules creation. </param>
        /// <param name="minAppIdVersion"> minimum version. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="securityServices"> Security Profile. </param>
        /// <returns> A new <see cref="Ngfw.GlobalRulestackData"/> instance for mocking. </returns>
        public static GlobalRulestackData GlobalRulestackData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation location = default, ManagedServiceIdentity identity = null, ETag? panETag = null, AzureLocation? panLocation = null, RulestackScopeType? scope = null, IEnumerable<string> associatedSubscriptions = null, string description = null, RuleCreationDefaultMode? defaultMode = null, string minAppIdVersion = null, FirewallProvisioningState? provisioningState = null, RulestackSecurityServices securityServices = null)
        {
            associatedSubscriptions ??= new List<string>();

            return new GlobalRulestackData(
                id,
                name,
                resourceType,
                systemData,
                location,
                identity,
                panETag,
                panLocation,
                scope,
                associatedSubscriptions?.ToList(),
                description,
                defaultMode,
                minAppIdVersion,
                provisioningState,
                securityServices,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.GlobalRulestackCertificateObjectData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="certificateSignerResourceId"> Resource Id of certificate signer, to be populated only when certificateSelfSigned is false. </param>
        /// <param name="certificateSelfSigned"> use certificate self signed. </param>
        /// <param name="auditComment"> comment for this object. </param>
        /// <param name="description"> user description for this object. </param>
        /// <param name="etag"> read only string representing last create or update. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.GlobalRulestackCertificateObjectData"/> instance for mocking. </returns>
        public static GlobalRulestackCertificateObjectData GlobalRulestackCertificateObjectData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string certificateSignerResourceId = null, FirewallBooleanType certificateSelfSigned = default, string auditComment = null, string description = null, ETag? etag = null, FirewallProvisioningState? provisioningState = null)
        {
            return new GlobalRulestackCertificateObjectData(
                id,
                name,
                resourceType,
                systemData,
                certificateSignerResourceId,
                certificateSelfSigned,
                auditComment,
                description,
                etag,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.GlobalRulestackFqdnData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> fqdn object description. </param>
        /// <param name="fqdnList"> fqdn list. </param>
        /// <param name="etag"> etag info. </param>
        /// <param name="auditComment"> comment for this object. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.GlobalRulestackFqdnData"/> instance for mocking. </returns>
        public static GlobalRulestackFqdnData GlobalRulestackFqdnData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<string> fqdnList = null, ETag? etag = null, string auditComment = null, FirewallProvisioningState? provisioningState = null)
        {
            fqdnList ??= new List<string>();

            return new GlobalRulestackFqdnData(
                id,
                name,
                resourceType,
                systemData,
                description,
                fqdnList?.ToList(),
                etag,
                auditComment,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RulestackChangelog"/>. </summary>
        /// <param name="changes"> list of changes. </param>
        /// <param name="lastCommittedOn"> lastCommitted timestamp. </param>
        /// <param name="lastModifiedOn"> lastModified timestamp. </param>
        /// <returns> A new <see cref="Models.RulestackChangelog"/> instance for mocking. </returns>
        public static RulestackChangelog RulestackChangelog(IEnumerable<string> changes = null, DateTimeOffset? lastCommittedOn = null, DateTimeOffset? lastModifiedOn = null)
        {
            changes ??= new List<string>();

            return new RulestackChangelog(changes?.ToList(), lastCommittedOn, lastModifiedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdvancedSecurityObjectListResult"/>. </summary>
        /// <param name="value"> response value. </param>
        /// <param name="nextLink"> next link. </param>
        /// <returns> A new <see cref="Models.AdvancedSecurityObjectListResult"/> instance for mocking. </returns>
        public static AdvancedSecurityObjectListResult AdvancedSecurityObjectListResult(AdvancedSecurityObject value = null, string nextLink = null)
        {
            return new AdvancedSecurityObjectListResult(value, nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdvancedSecurityObject"/>. </summary>
        /// <param name="advSecurityObjectModelType"> type of object. </param>
        /// <param name="entry"> URL entry. </param>
        /// <returns> A new <see cref="Models.AdvancedSecurityObject"/> instance for mocking. </returns>
        public static AdvancedSecurityObject AdvancedSecurityObject(string advSecurityObjectModelType = null, IEnumerable<NameDescriptionObject> entry = null)
        {
            entry ??= new List<NameDescriptionObject>();

            return new AdvancedSecurityObject(advSecurityObjectModelType, entry?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NameDescriptionObject"/>. </summary>
        /// <param name="name"> name value. </param>
        /// <param name="description"> description value. </param>
        /// <returns> A new <see cref="Models.NameDescriptionObject"/> instance for mocking. </returns>
        public static NameDescriptionObject NameDescriptionObject(string name = null, string description = null)
        {
            return new NameDescriptionObject(name, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RulestackCountry"/>. </summary>
        /// <param name="code"> country code. </param>
        /// <param name="description"> code description. </param>
        /// <returns> A new <see cref="Models.RulestackCountry"/> instance for mocking. </returns>
        public static RulestackCountry RulestackCountry(string code = null, string description = null)
        {
            return new RulestackCountry(code, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PredefinedUrlCategory"/>. </summary>
        /// <param name="action"></param>
        /// <param name="name"></param>
        /// <returns> A new <see cref="Models.PredefinedUrlCategory"/> instance for mocking. </returns>
        public static PredefinedUrlCategory PredefinedUrlCategory(string action = null, string name = null)
        {
            return new PredefinedUrlCategory(action, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RulestackSecurityServiceListResult"/>. </summary>
        /// <param name="value"> response value. </param>
        /// <param name="nextLink"> next link. </param>
        /// <returns> A new <see cref="Models.RulestackSecurityServiceListResult"/> instance for mocking. </returns>
        public static RulestackSecurityServiceListResult RulestackSecurityServiceListResult(RulestackSecurityServiceTypeList value = null, string nextLink = null)
        {
            return new RulestackSecurityServiceListResult(value, nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RulestackSecurityServiceTypeList"/>. </summary>
        /// <param name="securityServicesTypeListType"> security services type. </param>
        /// <param name="entry"> list. </param>
        /// <returns> A new <see cref="Models.RulestackSecurityServiceTypeList"/> instance for mocking. </returns>
        public static RulestackSecurityServiceTypeList RulestackSecurityServiceTypeList(string securityServicesTypeListType = null, IEnumerable<NameDescriptionObject> entry = null)
        {
            entry ??= new List<NameDescriptionObject>();

            return new RulestackSecurityServiceTypeList(securityServicesTypeListType, entry?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.PostRulestackRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> etag info. </param>
        /// <param name="ruleName"> rule name. </param>
        /// <param name="priority"></param>
        /// <param name="description"> rule description. </param>
        /// <param name="ruleState"> state of this rule. </param>
        /// <param name="source"> source address. </param>
        /// <param name="negateSource"> cidr should not be 'any'. </param>
        /// <param name="destination"> destination address. </param>
        /// <param name="negateDestination"> cidr should not be 'any'. </param>
        /// <param name="applications"> array of rule applications. </param>
        /// <param name="category"> rule category. </param>
        /// <param name="protocol"> any, application-default, TCP:number, UDP:number. </param>
        /// <param name="protocolPortList"> prot port list. </param>
        /// <param name="inboundInspectionCertificate"> inbound Inspection Certificate. </param>
        /// <param name="auditComment"> rule comment. </param>
        /// <param name="actionType"> rule action. </param>
        /// <param name="enableLogging"> enable or disable logging. </param>
        /// <param name="decryptionRuleType"> enable or disable decryption. </param>
        /// <param name="tags"> tag for rule. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.PostRulestackRuleData"/> instance for mocking. </returns>
        public static PostRulestackRuleData PostRulestackRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string ruleName = null, int? priority = null, string description = null, RulestackStateType? ruleState = null, SourceAddressInfo source = null, FirewallBooleanType? negateSource = null, DestinationAddressInfo destination = null, FirewallBooleanType? negateDestination = null, IEnumerable<string> applications = null, EdlMatchCategory category = null, string protocol = null, IEnumerable<string> protocolPortList = null, string inboundInspectionCertificate = null, string auditComment = null, RulestackActionType? actionType = null, RulestackStateType? enableLogging = null, DecryptionRuleType? decryptionRuleType = null, IEnumerable<RulestackTagInfo> tags = null, FirewallProvisioningState? provisioningState = null)
        {
            applications ??= new List<string>();
            protocolPortList ??= new List<string>();
            tags ??= new List<RulestackTagInfo>();

            return new PostRulestackRuleData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                ruleName,
                priority,
                description,
                ruleState,
                source,
                negateSource,
                destination,
                negateDestination,
                applications?.ToList(),
                category,
                protocol,
                protocolPortList?.ToList(),
                inboundInspectionCertificate,
                auditComment,
                actionType,
                enableLogging,
                decryptionRuleType,
                tags?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirewallRuleCounter"/>. </summary>
        /// <param name="priority"> priority number. </param>
        /// <param name="ruleStackName"> rule Stack Name. </param>
        /// <param name="ruleListName"> rule list name. </param>
        /// <param name="firewallName"> firewall name. </param>
        /// <param name="ruleName"> rule name. </param>
        /// <param name="hitCount"> hit count. </param>
        /// <param name="appSeen"> apps seen. </param>
        /// <param name="responseOn"> timestamp of response. </param>
        /// <param name="requestOn"> timestamp of request. </param>
        /// <param name="lastUpdatedOn"> last updated timestamp. </param>
        /// <returns> A new <see cref="Models.FirewallRuleCounter"/> instance for mocking. </returns>
        public static FirewallRuleCounter FirewallRuleCounter(string priority = null, string ruleStackName = null, string ruleListName = null, string firewallName = null, string ruleName = null, int? hitCount = null, AppSeenInfoList appSeen = null, DateTimeOffset? responseOn = null, DateTimeOffset? requestOn = null, DateTimeOffset? lastUpdatedOn = null)
        {
            return new FirewallRuleCounter(
                priority,
                ruleStackName,
                ruleListName,
                firewallName,
                ruleName,
                hitCount,
                appSeen,
                responseOn,
                requestOn,
                lastUpdatedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppSeenInfoList"/>. </summary>
        /// <param name="count"> number of rows. </param>
        /// <param name="appSeenList"> array of appSeen. </param>
        /// <returns> A new <see cref="Models.AppSeenInfoList"/> instance for mocking. </returns>
        public static AppSeenInfoList AppSeenInfoList(int count = default, IEnumerable<AppSeenInfo> appSeenList = null)
        {
            appSeenList ??= new List<AppSeenInfo>();

            return new AppSeenInfoList(count, appSeenList?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppSeenInfo"/>. </summary>
        /// <param name="title"> title. </param>
        /// <param name="category"> category. </param>
        /// <param name="subCategory"> subCategory. </param>
        /// <param name="risk"> risk. </param>
        /// <param name="tag"> tag. </param>
        /// <param name="technology"> technology. </param>
        /// <param name="standardPorts"> standardPorts. </param>
        /// <returns> A new <see cref="Models.AppSeenInfo"/> instance for mocking. </returns>
        public static AppSeenInfo AppSeenInfo(string title = null, string category = null, string subCategory = null, string risk = null, string tag = null, string technology = null, string standardPorts = null)
        {
            return new AppSeenInfo(
                title,
                category,
                subCategory,
                risk,
                tag,
                technology,
                standardPorts,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirewallRuleResetConter"/>. </summary>
        /// <param name="priority"> priority number. </param>
        /// <param name="ruleStackName"> rule Stack Name. </param>
        /// <param name="ruleListName"> rule list name. </param>
        /// <param name="firewallName"> firewall name. </param>
        /// <param name="ruleName"> rule name. </param>
        /// <returns> A new <see cref="Models.FirewallRuleResetConter"/> instance for mocking. </returns>
        public static FirewallRuleResetConter FirewallRuleResetConter(string priority = null, string ruleStackName = null, string ruleListName = null, string firewallName = null, string ruleName = null)
        {
            return new FirewallRuleResetConter(
                priority,
                ruleStackName,
                ruleListName,
                firewallName,
                ruleName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.GlobalRulestackPrefixData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> prefix description. </param>
        /// <param name="prefixList"> prefix list. </param>
        /// <param name="etag"> etag info. </param>
        /// <param name="auditComment"> comment for this object. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.GlobalRulestackPrefixData"/> instance for mocking. </returns>
        public static GlobalRulestackPrefixData GlobalRulestackPrefixData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<string> prefixList = null, ETag? etag = null, string auditComment = null, FirewallProvisioningState? provisioningState = null)
        {
            prefixList ??= new List<string>();

            return new GlobalRulestackPrefixData(
                id,
                name,
                resourceType,
                systemData,
                description,
                prefixList?.ToList(),
                etag,
                auditComment,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.PreRulestackRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> etag info. </param>
        /// <param name="ruleName"> rule name. </param>
        /// <param name="priority"></param>
        /// <param name="description"> rule description. </param>
        /// <param name="ruleState"> state of this rule. </param>
        /// <param name="source"> source address. </param>
        /// <param name="negateSource"> cidr should not be 'any'. </param>
        /// <param name="destination"> destination address. </param>
        /// <param name="negateDestination"> cidr should not be 'any'. </param>
        /// <param name="applications"> array of rule applications. </param>
        /// <param name="category"> rule category. </param>
        /// <param name="protocol"> any, application-default, TCP:number, UDP:number. </param>
        /// <param name="protocolPortList"> prot port list. </param>
        /// <param name="inboundInspectionCertificate"> inbound Inspection Certificate. </param>
        /// <param name="auditComment"> rule comment. </param>
        /// <param name="actionType"> rule action. </param>
        /// <param name="enableLogging"> enable or disable logging. </param>
        /// <param name="decryptionRuleType"> enable or disable decryption. </param>
        /// <param name="tags"> tag for rule. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.PreRulestackRuleData"/> instance for mocking. </returns>
        public static PreRulestackRuleData PreRulestackRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string ruleName = null, int? priority = null, string description = null, RulestackStateType? ruleState = null, SourceAddressInfo source = null, FirewallBooleanType? negateSource = null, DestinationAddressInfo destination = null, FirewallBooleanType? negateDestination = null, IEnumerable<string> applications = null, EdlMatchCategory category = null, string protocol = null, IEnumerable<string> protocolPortList = null, string inboundInspectionCertificate = null, string auditComment = null, RulestackActionType? actionType = null, RulestackStateType? enableLogging = null, DecryptionRuleType? decryptionRuleType = null, IEnumerable<RulestackTagInfo> tags = null, FirewallProvisioningState? provisioningState = null)
        {
            applications ??= new List<string>();
            protocolPortList ??= new List<string>();
            tags ??= new List<RulestackTagInfo>();

            return new PreRulestackRuleData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                ruleName,
                priority,
                description,
                ruleState,
                source,
                negateSource,
                destination,
                negateDestination,
                applications?.ToList(),
                category,
                protocol,
                protocolPortList?.ToList(),
                inboundInspectionCertificate,
                auditComment,
                actionType,
                enableLogging,
                decryptionRuleType,
                tags?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.PaloAltoNetworksFirewallData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The managed service identities assigned to this resource. </param>
        /// <param name="panETag"> panEtag info. </param>
        /// <param name="networkProfile"> Network settings. </param>
        /// <param name="isPanoramaManaged"> Panorama Managed: Default is False. Default will be CloudSec managed. </param>
        /// <param name="panoramaConfig"> Panorama Configuration. </param>
        /// <param name="associatedRulestack"> Associated Rulestack. </param>
        /// <param name="dnsSettings"> DNS settings for Firewall. </param>
        /// <param name="frontEndSettings"> Frontend settings for Firewall. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="planData"> Billing plan information. </param>
        /// <param name="marketplaceDetails"> Marketplace details. </param>
        /// <returns> A new <see cref="Ngfw.PaloAltoNetworksFirewallData"/> instance for mocking. </returns>
        public static PaloAltoNetworksFirewallData PaloAltoNetworksFirewallData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, ETag? panETag = null, FirewallNetworkProfile networkProfile = null, FirewallBooleanType? isPanoramaManaged = null, FirewallPanoramaConfiguration panoramaConfig = null, RulestackDetails associatedRulestack = null, FirewallDnsSettings dnsSettings = null, IEnumerable<FirewallFrontendSetting> frontEndSettings = null, FirewallProvisioningState? provisioningState = null, FirewallBillingPlanInfo planData = null, PanFirewallMarketplaceDetails marketplaceDetails = null)
        {
            tags ??= new Dictionary<string, string>();
            frontEndSettings ??= new List<FirewallFrontendSetting>();

            return new PaloAltoNetworksFirewallData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                panETag,
                networkProfile,
                isPanoramaManaged,
                panoramaConfig,
                associatedRulestack,
                dnsSettings,
                frontEndSettings?.ToList(),
                provisioningState,
                planData,
                marketplaceDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirewallPanoramaConfiguration"/>. </summary>
        /// <param name="configString"> Base64 encoded string representing Panorama parameters to be used by Firewall to connect to Panorama. This string is generated via azure plugin in Panorama. </param>
        /// <param name="vmAuthKey"> VM auth key for panorama connectivity. </param>
        /// <param name="panoramaServer"> Primary Panorama Server IP address value in dotted format for IPv4. </param>
        /// <param name="panoramaServer2"> Secondary Panorama Server IP address value in dotted format for IPv4. </param>
        /// <param name="dgName"> Panorama Device Group to join. </param>
        /// <param name="tplName"> Panorama Template Stack to join - (Once configured we can not edit the value). </param>
        /// <param name="cgName"> Panorama Collector Group to join - (Once configured we can not edit the value). </param>
        /// <param name="hostName"> Resource name(may be unique) for PN admin. </param>
        /// <returns> A new <see cref="Models.FirewallPanoramaConfiguration"/> instance for mocking. </returns>
        public static FirewallPanoramaConfiguration FirewallPanoramaConfiguration(string configString = null, string vmAuthKey = null, string panoramaServer = null, string panoramaServer2 = null, string dgName = null, string tplName = null, string cgName = null, string hostName = null)
        {
            return new FirewallPanoramaConfiguration(
                configString,
                vmAuthKey,
                panoramaServer,
                panoramaServer2,
                dgName,
                tplName,
                cgName,
                hostName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirewallBillingPlanInfo"/>. </summary>
        /// <param name="usageType"> different usage type like PAYG/COMMITTED. </param>
        /// <param name="billingCycle"> different billing cycles like MONTHLY/WEEKLY. </param>
        /// <param name="planId"> plan id as published by Liftr.PAN. </param>
        /// <param name="effectiveOn"> date when plan was applied. </param>
        /// <returns> A new <see cref="Models.FirewallBillingPlanInfo"/> instance for mocking. </returns>
        public static FirewallBillingPlanInfo FirewallBillingPlanInfo(FirewallBillingPlanUsageType? usageType = null, FirewallBillingCycle billingCycle = default, string planId = null, DateTimeOffset? effectiveOn = null)
        {
            return new FirewallBillingPlanInfo(usageType, billingCycle, planId, effectiveOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PanFirewallMarketplaceDetails"/>. </summary>
        /// <param name="marketplaceSubscriptionId"> Marketplace Subscription Id. </param>
        /// <param name="offerId"> Offer Id. </param>
        /// <param name="publisherId"> Publisher Id. </param>
        /// <param name="marketplaceSubscriptionStatus"> Marketplace Subscription Status. </param>
        /// <returns> A new <see cref="Models.PanFirewallMarketplaceDetails"/> instance for mocking. </returns>
        public static PanFirewallMarketplaceDetails PanFirewallMarketplaceDetails(string marketplaceSubscriptionId = null, string offerId = null, string publisherId = null, MarketplaceSubscriptionStatus? marketplaceSubscriptionStatus = null)
        {
            return new PanFirewallMarketplaceDetails(marketplaceSubscriptionId, offerId, publisherId, marketplaceSubscriptionStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.LocalRulestackData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The managed service identities assigned to this resource. </param>
        /// <param name="panETag"> PanEtag info. </param>
        /// <param name="panLocation"> Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks. </param>
        /// <param name="scope"> Rulestack Type. </param>
        /// <param name="associatedSubscriptions"> subscription scope of global rulestack. </param>
        /// <param name="description"> rulestack description. </param>
        /// <param name="defaultMode"> Mode for default rules creation. </param>
        /// <param name="minAppIdVersion"> minimum version. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="securityServices"> Security Profile. </param>
        /// <returns> A new <see cref="Ngfw.LocalRulestackData"/> instance for mocking. </returns>
        public static LocalRulestackData LocalRulestackData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, ETag? panETag = null, AzureLocation? panLocation = null, RulestackScopeType? scope = null, IEnumerable<string> associatedSubscriptions = null, string description = null, RuleCreationDefaultMode? defaultMode = null, string minAppIdVersion = null, FirewallProvisioningState? provisioningState = null, RulestackSecurityServices securityServices = null)
        {
            tags ??= new Dictionary<string, string>();
            associatedSubscriptions ??= new List<string>();

            return new LocalRulestackData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                panETag,
                panLocation,
                scope,
                associatedSubscriptions?.ToList(),
                description,
                defaultMode,
                minAppIdVersion,
                provisioningState,
                securityServices,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GlobalRulestackInfo"/>. </summary>
        /// <param name="azureId"> rulestack description. </param>
        /// <returns> A new <see cref="Models.GlobalRulestackInfo"/> instance for mocking. </returns>
        public static GlobalRulestackInfo GlobalRulestackInfo(string azureId = null)
        {
            return new GlobalRulestackInfo(azureId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirewallSupportInfo"/>. </summary>
        /// <param name="productSku"> product SKU associated with given resource. </param>
        /// <param name="productSerial"> product Serial associated with given resource. </param>
        /// <param name="accountRegistered"> account registered in Customer Support Portal. </param>
        /// <param name="accountId"> Support account associated with given resource. </param>
        /// <param name="userDomainSupported"> user domain is supported in Customer Support Portal. </param>
        /// <param name="userRegistered"> user registered in Customer Support Portal. </param>
        /// <param name="freeTrial"> Product usage is in free trial period. </param>
        /// <param name="freeTrialDaysLeft"> Free trial days remaining. </param>
        /// <param name="freeTrialCreditLeft"> Free trial credit remaining. </param>
        /// <param name="helpURL"> URL for paloaltonetworks live community. </param>
        /// <param name="supportURL"> URL for paloaltonetworks Customer Service Portal. </param>
        /// <param name="registerURL"> URL for registering product in paloaltonetworks Customer Service Portal. </param>
        /// <returns> A new <see cref="Models.FirewallSupportInfo"/> instance for mocking. </returns>
        public static FirewallSupportInfo FirewallSupportInfo(string productSku = null, string productSerial = null, FirewallBooleanType? accountRegistered = null, string accountId = null, FirewallBooleanType? userDomainSupported = null, FirewallBooleanType? userRegistered = null, FirewallBooleanType? freeTrial = null, int? freeTrialDaysLeft = null, int? freeTrialCreditLeft = null, string helpURL = null, string supportURL = null, string registerURL = null)
        {
            return new FirewallSupportInfo(
                productSku,
                productSerial,
                accountRegistered,
                accountId,
                userDomainSupported,
                userRegistered,
                freeTrial,
                freeTrialDaysLeft,
                freeTrialCreditLeft,
                helpURL,
                supportURL,
                registerURL,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.PaloAltoNetworksFirewallStatusData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isPanoramaManaged"> Panorama Managed: Default is False. Default will be CloudSec managed. </param>
        /// <param name="healthStatus"> Current status of the Firewall. </param>
        /// <param name="healthReason"> Detail description of current health of the Firewall. </param>
        /// <param name="panoramaStatus"> Panorama Status. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.PaloAltoNetworksFirewallStatusData"/> instance for mocking. </returns>
        public static PaloAltoNetworksFirewallStatusData PaloAltoNetworksFirewallStatusData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, FirewallBooleanType? isPanoramaManaged = null, FirewallHealthStatus? healthStatus = null, string healthReason = null, FirewallPanoramaStatus panoramaStatus = null, FirewallProvisioningStateType? provisioningState = null)
        {
            return new PaloAltoNetworksFirewallStatusData(
                id,
                name,
                resourceType,
                systemData,
                isPanoramaManaged,
                healthStatus,
                healthReason,
                panoramaStatus,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirewallPanoramaStatus"/>. </summary>
        /// <param name="panoramaServerStatus"> Primary Panorama connection status. </param>
        /// <param name="panoramaServer2Status"> Secondary Panorama connection status. </param>
        /// <returns> A new <see cref="Models.FirewallPanoramaStatus"/> instance for mocking. </returns>
        public static FirewallPanoramaStatus FirewallPanoramaStatus(FirewallPanoramaServerStatus? panoramaServerStatus = null, FirewallPanoramaServerStatus? panoramaServer2Status = null)
        {
            return new FirewallPanoramaStatus(panoramaServerStatus, panoramaServer2Status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.LocalRulestackCertificateObjectData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="certificateSignerResourceId"> Resource Id of certificate signer, to be populated only when certificateSelfSigned is false. </param>
        /// <param name="certificateSelfSigned"> use certificate self signed. </param>
        /// <param name="auditComment"> comment for this object. </param>
        /// <param name="description"> user description for this object. </param>
        /// <param name="etag"> read only string representing last create or update. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.LocalRulestackCertificateObjectData"/> instance for mocking. </returns>
        public static LocalRulestackCertificateObjectData LocalRulestackCertificateObjectData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string certificateSignerResourceId = null, FirewallBooleanType certificateSelfSigned = default, string auditComment = null, string description = null, ETag? etag = null, FirewallProvisioningState? provisioningState = null)
        {
            return new LocalRulestackCertificateObjectData(
                id,
                name,
                resourceType,
                systemData,
                certificateSignerResourceId,
                certificateSelfSigned,
                auditComment,
                description,
                etag,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.LocalRulestackFqdnData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> fqdn object description. </param>
        /// <param name="fqdnList"> fqdn list. </param>
        /// <param name="etag"> etag info. </param>
        /// <param name="auditComment"> comment for this object. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.LocalRulestackFqdnData"/> instance for mocking. </returns>
        public static LocalRulestackFqdnData LocalRulestackFqdnData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<string> fqdnList = null, ETag? etag = null, string auditComment = null, FirewallProvisioningState? provisioningState = null)
        {
            fqdnList ??= new List<string>();

            return new LocalRulestackFqdnData(
                id,
                name,
                resourceType,
                systemData,
                description,
                fqdnList?.ToList(),
                etag,
                auditComment,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.LocalRulestackRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> etag info. </param>
        /// <param name="ruleName"> rule name. </param>
        /// <param name="priority"></param>
        /// <param name="description"> rule description. </param>
        /// <param name="ruleState"> state of this rule. </param>
        /// <param name="source"> source address. </param>
        /// <param name="negateSource"> cidr should not be 'any'. </param>
        /// <param name="destination"> destination address. </param>
        /// <param name="negateDestination"> cidr should not be 'any'. </param>
        /// <param name="applications"> array of rule applications. </param>
        /// <param name="category"> rule category. </param>
        /// <param name="protocol"> any, application-default, TCP:number, UDP:number. </param>
        /// <param name="protocolPortList"> prot port list. </param>
        /// <param name="inboundInspectionCertificate"> inbound Inspection Certificate. </param>
        /// <param name="auditComment"> rule comment. </param>
        /// <param name="actionType"> rule action. </param>
        /// <param name="enableLogging"> enable or disable logging. </param>
        /// <param name="decryptionRuleType"> enable or disable decryption. </param>
        /// <param name="tags"> tag for rule. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.LocalRulestackRuleData"/> instance for mocking. </returns>
        public static LocalRulestackRuleData LocalRulestackRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string ruleName = null, int? priority = null, string description = null, RulestackStateType? ruleState = null, SourceAddressInfo source = null, FirewallBooleanType? negateSource = null, DestinationAddressInfo destination = null, FirewallBooleanType? negateDestination = null, IEnumerable<string> applications = null, EdlMatchCategory category = null, string protocol = null, IEnumerable<string> protocolPortList = null, string inboundInspectionCertificate = null, string auditComment = null, RulestackActionType? actionType = null, RulestackStateType? enableLogging = null, DecryptionRuleType? decryptionRuleType = null, IEnumerable<RulestackTagInfo> tags = null, FirewallProvisioningState? provisioningState = null)
        {
            applications ??= new List<string>();
            protocolPortList ??= new List<string>();
            tags ??= new List<RulestackTagInfo>();

            return new LocalRulestackRuleData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                ruleName,
                priority,
                description,
                ruleState,
                source,
                negateSource,
                destination,
                negateDestination,
                applications?.ToList(),
                category,
                protocol,
                protocolPortList?.ToList(),
                inboundInspectionCertificate,
                auditComment,
                actionType,
                enableLogging,
                decryptionRuleType,
                tags?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Ngfw.LocalRulestackPrefixData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> prefix description. </param>
        /// <param name="prefixList"> prefix list. </param>
        /// <param name="etag"> etag info. </param>
        /// <param name="auditComment"> comment for this object. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Ngfw.LocalRulestackPrefixData"/> instance for mocking. </returns>
        public static LocalRulestackPrefixData LocalRulestackPrefixData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<string> prefixList = null, ETag? etag = null, string auditComment = null, FirewallProvisioningState? provisioningState = null)
        {
            prefixList ??= new List<string>();

            return new LocalRulestackPrefixData(
                id,
                name,
                resourceType,
                systemData,
                description,
                prefixList?.ToList(),
                etag,
                auditComment,
                provisioningState,
                serializedAdditionalRawData: null);
        }
    }
}
