// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Samples
{
    public partial class Sample_PreRulestackRuleResource
    {
        // PreRules_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PreRulesGetMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "PreRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            PreRulestackRuleResource result = await preRulestackRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PreRulestackRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PreRules_Get_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PreRulesGetMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_Get_MinimumSet_Gen.json
            // this example is just showing the usage of "PreRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            PreRulestackRuleResource result = await preRulestackRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PreRulestackRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PreRules_CreateOrUpdate_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PreRulesCreateOrUpdateMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_CreateOrUpdate_MaximumSet_Gen.json
            // this example is just showing the usage of "PreRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            PreRulestackRuleData data = new PreRulestackRuleData("preRule1")
            {
                ETag = new ETag("c18e6eef-ba3e-49ee-8a85-2b36c863a9d0"),
                Description = "description of pre rule",
                RuleState = RulestackStateType.Disabled,
                Source = new SourceAddressInfo()
                {
                    Cidrs =
{
"1.0.0.1/10"
},
                    Countries =
{
"India"
},
                    Feeds =
{
"feed"
},
                    PrefixLists =
{
"PL1"
},
                },
                NegateSource = FirewallBooleanType.True,
                Destination = new DestinationAddressInfo()
                {
                    Cidrs =
{
"1.0.0.1/10"
},
                    Countries =
{
"India"
},
                    Feeds =
{
"feed"
},
                    PrefixLists =
{
"PL1"
},
                    FqdnLists =
{
"FQDN1"
},
                },
                NegateDestination = FirewallBooleanType.True,
                Applications =
{
"app1"
},
                Category = new EdlMatchCategory(new string[]
            {
"https://microsoft.com"
            }, new string[]
            {
"feed"
            }),
                Protocol = "HTTP",
                ProtocolPortList =
{
"80"
},
                InboundInspectionCertificate = "cert1",
                AuditComment = "example comment",
                ActionType = RulestackActionType.Allow,
                EnableLogging = RulestackStateType.Disabled,
                DecryptionRuleType = DecryptionRuleType.SslOutboundInspection,
                Tags =
{
new RulestackTagInfo("keyName","value")
},
            };
            ArmOperation<PreRulestackRuleResource> lro = await preRulestackRule.UpdateAsync(WaitUntil.Completed, data);
            PreRulestackRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PreRulestackRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PreRules_CreateOrUpdate_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PreRulesCreateOrUpdateMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_CreateOrUpdate_MinimumSet_Gen.json
            // this example is just showing the usage of "PreRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            PreRulestackRuleData data = new PreRulestackRuleData("preRule1");
            ArmOperation<PreRulestackRuleResource> lro = await preRulestackRule.UpdateAsync(WaitUntil.Completed, data);
            PreRulestackRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PreRulestackRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PreRules_Delete_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PreRulesDeleteMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_Delete_MaximumSet_Gen.json
            // this example is just showing the usage of "PreRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            await preRulestackRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // PreRules_Delete_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PreRulesDeleteMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_Delete_MinimumSet_Gen.json
            // this example is just showing the usage of "PreRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            await preRulestackRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // PreRules_getCounters_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetCounters_PreRulesGetCountersMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_getCounters_MaximumSet_Gen.json
            // this example is just showing the usage of "PreRules_GetCounters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            string firewallName = "firewall1";
            FirewallRuleCounter result = await preRulestackRule.GetCountersAsync(firewallName: firewallName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // PreRules_getCounters_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetCounters_PreRulesGetCountersMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_getCounters_MinimumSet_Gen.json
            // this example is just showing the usage of "PreRules_GetCounters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            FirewallRuleCounter result = await preRulestackRule.GetCountersAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // PreRules_refreshCounters_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RefreshCounters_PreRulesRefreshCountersMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_refreshCounters_MaximumSet_Gen.json
            // this example is just showing the usage of "PreRules_RefreshCounters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            string firewallName = "firewall1";
            await preRulestackRule.RefreshCountersAsync(firewallName: firewallName);

            Console.WriteLine($"Succeeded");
        }

        // PreRules_refreshCounters_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RefreshCounters_PreRulesRefreshCountersMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_refreshCounters_MinimumSet_Gen.json
            // this example is just showing the usage of "PreRules_RefreshCounters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            await preRulestackRule.RefreshCountersAsync();

            Console.WriteLine($"Succeeded");
        }

        // PreRules_resetCounters_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ResetCounters_PreRulesResetCountersMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_resetCounters_MaximumSet_Gen.json
            // this example is just showing the usage of "PreRules_ResetCounters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            string firewallName = "firewall1";
            FirewallRuleResetConter result = await preRulestackRule.ResetCountersAsync(firewallName: firewallName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // PreRules_resetCounters_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ResetCounters_PreRulesResetCountersMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/PreRules_resetCounters_MinimumSet_Gen.json
            // this example is just showing the usage of "PreRules_ResetCounters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PreRulestackRuleResource created on azure
            // for more information of creating PreRulestackRuleResource, please refer to the document of PreRulestackRuleResource
            string globalRulestackName = "lrs1";
            string priority = "1";
            ResourceIdentifier preRulestackRuleResourceId = PreRulestackRuleResource.CreateResourceIdentifier(globalRulestackName, priority);
            PreRulestackRuleResource preRulestackRule = client.GetPreRulestackRuleResource(preRulestackRuleResourceId);

            // invoke the operation
            FirewallRuleResetConter result = await preRulestackRule.ResetCountersAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
