// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Samples
{
    public partial class Sample_PaloAltoNetworksFirewallStatusResource
    {
        // FirewallStatus_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_FirewallStatusGetMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/FirewallStatus_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "FirewallStatus_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallStatusResource created on azure
            // for more information of creating PaloAltoNetworksFirewallStatusResource, please refer to the document of PaloAltoNetworksFirewallStatusResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "rgopenapi";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallStatusResourceId = PaloAltoNetworksFirewallStatusResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallStatusResource paloAltoNetworksFirewallStatus = client.GetPaloAltoNetworksFirewallStatusResource(paloAltoNetworksFirewallStatusResourceId);

            // invoke the operation
            PaloAltoNetworksFirewallStatusResource result = await paloAltoNetworksFirewallStatus.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PaloAltoNetworksFirewallStatusData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // FirewallStatus_Get_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_FirewallStatusGetMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/FirewallStatus_Get_MinimumSet_Gen.json
            // this example is just showing the usage of "FirewallStatus_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallStatusResource created on azure
            // for more information of creating PaloAltoNetworksFirewallStatusResource, please refer to the document of PaloAltoNetworksFirewallStatusResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "rgopenapi";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallStatusResourceId = PaloAltoNetworksFirewallStatusResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallStatusResource paloAltoNetworksFirewallStatus = client.GetPaloAltoNetworksFirewallStatusResource(paloAltoNetworksFirewallStatusResourceId);

            // invoke the operation
            PaloAltoNetworksFirewallStatusResource result = await paloAltoNetworksFirewallStatus.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PaloAltoNetworksFirewallStatusData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
