// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Samples
{
    public partial class Sample_PaloAltoNetworksFirewallResource
    {
        // Firewalls_ListBySubscription_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetPaloAltoNetworksFirewalls_FirewallsListBySubscriptionMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_ListBySubscription_MaximumSet_Gen.json
            // this example is just showing the usage of "Firewalls_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (PaloAltoNetworksFirewallResource item in subscriptionResource.GetPaloAltoNetworksFirewallsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PaloAltoNetworksFirewallData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Firewalls_ListBySubscription_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetPaloAltoNetworksFirewalls_FirewallsListBySubscriptionMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_ListBySubscription_MinimumSet_Gen.json
            // this example is just showing the usage of "Firewalls_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (PaloAltoNetworksFirewallResource item in subscriptionResource.GetPaloAltoNetworksFirewallsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PaloAltoNetworksFirewallData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Firewalls_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_FirewallsGetMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "Firewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            PaloAltoNetworksFirewallResource result = await paloAltoNetworksFirewall.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PaloAltoNetworksFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Firewalls_Get_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_FirewallsGetMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Get_MinimumSet_Gen.json
            // this example is just showing the usage of "Firewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            PaloAltoNetworksFirewallResource result = await paloAltoNetworksFirewall.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PaloAltoNetworksFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Firewalls_Update_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_FirewallsUpdateMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Update_MaximumSet_Gen.json
            // this example is just showing the usage of "Firewalls_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            PaloAltoNetworksFirewallPatch patch = new PaloAltoNetworksFirewallPatch()
            {
                Identity = new ManagedServiceIdentity("None")
                {
                    UserAssignedIdentities =
{
[new ResourceIdentifier("key16")] = new UserAssignedIdentity(),
},
                },
                Tags =
{
["tagName"] = "value",
},
                Properties = new FirewallUpdateProperties()
                {
                    PanETag = new ETag("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
                    NetworkProfile = new FirewallNetworkProfile(FirewallNetworkType.Vnet, new IPAddressInfo[]
            {
new IPAddressInfo()
{
ResourceId = new ResourceIdentifier("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
Address = "20.22.92.11",
}
            }, AllowEgressNatType.Enabled)
                    {
                        VnetConfiguration = new FirewallVnetConfiguration(new IPAddressSpaceInfo()
                        {
                            ResourceId = new ResourceIdentifier("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
                            AddressSpace = "10.1.0.0/16",
                        }, new IPAddressSpaceInfo()
                        {
                            ResourceId = new ResourceIdentifier("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
                            AddressSpace = "10.1.1.0/24",
                        }, new IPAddressSpaceInfo()
                        {
                            ResourceId = new ResourceIdentifier("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
                            AddressSpace = "10.1.1.0/24",
                        })
                        {
                            IPOfTrustSubnetForUdr = new IPAddressInfo()
                            {
                                ResourceId = new ResourceIdentifier("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
                                Address = "10.1.1.0/24",
                            },
                        },
                        VwanConfiguration = new FirewallVwanConfiguration(new IPAddressSpaceInfo()
                        {
                            ResourceId = new ResourceIdentifier("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
                            AddressSpace = "10.1.1.0/24",
                        })
                        {
                            NetworkVirtualApplianceId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c12",
                            TrustSubnet = new IPAddressSpaceInfo()
                            {
                                ResourceId = new ResourceIdentifier("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
                                AddressSpace = "10.1.1.0/24",
                            },
                            UnTrustSubnet = new IPAddressSpaceInfo()
                            {
                                ResourceId = new ResourceIdentifier("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
                                AddressSpace = "10.1.1.0/24",
                            },
                            IPOfTrustSubnetForUdr = new IPAddressInfo()
                            {
                                ResourceId = new ResourceIdentifier("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
                                Address = "10.1.1.0/24",
                            },
                        },
                        EgressNatIP =
{
new IPAddressInfo()
{
ResourceId = new ResourceIdentifier("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
Address = "20.22.92.111",
}
},
                        TrustedRanges =
{
"20.22.92.11"
},
                    },
                    IsPanoramaManaged = FirewallBooleanType.True,
                    PanoramaConfig = new FirewallPanoramaConfiguration("bas64EncodedString"),
                    AssociatedRulestack = new RulestackDetails()
                    {
                        ResourceId = new ResourceIdentifier("aaaaaaaaaa"),
                        RulestackId = "aaaaaaaaaaaaaaaa",
                        Location = new AzureLocation("eastus"),
                    },
                    DnsSettings = new FirewallDnsSettings()
                    {
                        EnableDnsProxy = AllowDnsProxyType.Disabled,
                        EnabledDnsType = EnabledDnsType.Custom,
                        DnsServers =
{
new IPAddressInfo()
{
ResourceId = new ResourceIdentifier("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
Address = "20.22.92.111",
}
},
                    },
                    FrontEndSettings =
{
new FirewallFrontendSetting("frontendsetting11",FirewallProtocolType.Tcp,new FirewallEndpointConfiguration("80",new IPAddressInfo()
{
ResourceId = new ResourceIdentifier("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
Address = "20.22.91.251",
}),new FirewallEndpointConfiguration("80",new IPAddressInfo()
{
ResourceId = new ResourceIdentifier("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
Address = "20.22.32.136",
}))
},
                    PlanData = new FirewallBillingPlanInfo(FirewallBillingCycle.Weekly, "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")
                    {
                        UsageType = FirewallBillingPlanUsageType.Payg,
                    },
                    MarketplaceDetails = new PanFirewallMarketplaceDetails("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaa")
                    {
                        MarketplaceSubscriptionStatus = MarketplaceSubscriptionStatus.PendingFulfillmentStart,
                    },
                },
            };
            PaloAltoNetworksFirewallResource result = await paloAltoNetworksFirewall.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PaloAltoNetworksFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Firewalls_Update_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_FirewallsUpdateMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Update_MinimumSet_Gen.json
            // this example is just showing the usage of "Firewalls_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            PaloAltoNetworksFirewallPatch patch = new PaloAltoNetworksFirewallPatch();
            PaloAltoNetworksFirewallResource result = await paloAltoNetworksFirewall.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PaloAltoNetworksFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Firewalls_Delete_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_FirewallsDeleteMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Delete_MaximumSet_Gen.json
            // this example is just showing the usage of "Firewalls_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            await paloAltoNetworksFirewall.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Firewalls_Delete_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_FirewallsDeleteMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_Delete_MinimumSet_Gen.json
            // this example is just showing the usage of "Firewalls_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            await paloAltoNetworksFirewall.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Firewalls_getGlobalRulestack_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetGlobalRulestack_FirewallsGetGlobalRulestackMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getGlobalRulestack_MaximumSet_Gen.json
            // this example is just showing the usage of "Firewalls_GetGlobalRulestack" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            GlobalRulestackInfo result = await paloAltoNetworksFirewall.GetGlobalRulestackAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Firewalls_getGlobalRulestack_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetGlobalRulestack_FirewallsGetGlobalRulestackMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getGlobalRulestack_MinimumSet_Gen.json
            // this example is just showing the usage of "Firewalls_GetGlobalRulestack" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            GlobalRulestackInfo result = await paloAltoNetworksFirewall.GetGlobalRulestackAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Firewalls_getLogProfile_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetLogProfile_FirewallsGetLogProfileMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getLogProfile_MaximumSet_Gen.json
            // this example is just showing the usage of "Firewalls_GetLogProfile" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            FirewallLogSettings result = await paloAltoNetworksFirewall.GetLogProfileAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Firewalls_getLogProfile_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetLogProfile_FirewallsGetLogProfileMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getLogProfile_MinimumSet_Gen.json
            // this example is just showing the usage of "Firewalls_GetLogProfile" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            FirewallLogSettings result = await paloAltoNetworksFirewall.GetLogProfileAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Firewalls_getSupportInfo_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSupportInfo_FirewallsGetSupportInfoMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getSupportInfo_MaximumSet_Gen.json
            // this example is just showing the usage of "Firewalls_GetSupportInfo" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "rgopenapi";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            string email = "user1@domain.com";
            FirewallSupportInfo result = await paloAltoNetworksFirewall.GetSupportInfoAsync(email: email);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Firewalls_getSupportInfo_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSupportInfo_FirewallsGetSupportInfoMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_getSupportInfo_MinimumSet_Gen.json
            // this example is just showing the usage of "Firewalls_GetSupportInfo" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "rgopenapi";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            FirewallSupportInfo result = await paloAltoNetworksFirewall.GetSupportInfoAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Firewalls_saveLogProfile_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SaveLogProfile_FirewallsSaveLogProfileMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_saveLogProfile_MaximumSet_Gen.json
            // this example is just showing the usage of "Firewalls_SaveLogProfile" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            FirewallLogSettings logSettings = new FirewallLogSettings()
            {
                LogType = FirewallLogType.Traffic,
                LogOption = FirewallLogOption.SameDestination,
                ApplicationInsights = new FirewallApplicationInsights()
                {
                    Id = "aaaaaaaaaaaaaaaa",
                    Key = "aaaaaaaaaaaaa",
                },
                CommonDestination = new FirewallLogDestination()
                {
                    StorageConfiguration = new StorageAccountConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaa",
                        AccountName = "aaaaaaaaaaaaaaaaaaaaaaa",
                    },
                    EventHubConfiguration = new EventHubConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaaa",
                        Name = "aaaaaaaa",
                        NameSpace = "aaaaaaaaaaaaaaaaaaaaa",
                        PolicyName = "aaaaaaaaaaaa",
                    },
                    MonitorConfiguration = new MonitorLogConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaaaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaaaaaa",
                        Workspace = "aaaaaaaaaaa",
                        PrimaryKey = "aaaaaaaaaaaaa",
                        SecondaryKey = "a",
                    },
                },
                TrafficLogDestination = new FirewallLogDestination()
                {
                    StorageConfiguration = new StorageAccountConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaa",
                        AccountName = "aaaaaaaaaaaaaaaaaaaaaaa",
                    },
                    EventHubConfiguration = new EventHubConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaaa",
                        Name = "aaaaaaaa",
                        NameSpace = "aaaaaaaaaaaaaaaaaaaaa",
                        PolicyName = "aaaaaaaaaaaa",
                    },
                    MonitorConfiguration = new MonitorLogConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaaaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaaaaaa",
                        Workspace = "aaaaaaaaaaa",
                        PrimaryKey = "aaaaaaaaaaaaa",
                        SecondaryKey = "a",
                    },
                },
                ThreatLogDestination = new FirewallLogDestination()
                {
                    StorageConfiguration = new StorageAccountConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaa",
                        AccountName = "aaaaaaaaaaaaaaaaaaaaaaa",
                    },
                    EventHubConfiguration = new EventHubConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaaa",
                        Name = "aaaaaaaa",
                        NameSpace = "aaaaaaaaaaaaaaaaaaaaa",
                        PolicyName = "aaaaaaaaaaaa",
                    },
                    MonitorConfiguration = new MonitorLogConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaaaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaaaaaa",
                        Workspace = "aaaaaaaaaaa",
                        PrimaryKey = "aaaaaaaaaaaaa",
                        SecondaryKey = "a",
                    },
                },
                DecryptLogDestination = new FirewallLogDestination()
                {
                    StorageConfiguration = new StorageAccountConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaa",
                        AccountName = "aaaaaaaaaaaaaaaaaaaaaaa",
                    },
                    EventHubConfiguration = new EventHubConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaaa",
                        Name = "aaaaaaaa",
                        NameSpace = "aaaaaaaaaaaaaaaaaaaaa",
                        PolicyName = "aaaaaaaaaaaa",
                    },
                    MonitorConfiguration = new MonitorLogConfiguration()
                    {
                        Id = new ResourceIdentifier("aaaaaaaaaaaaaaaaaaa"),
                        SubscriptionId = "aaaaaaaaaaaaa",
                        Workspace = "aaaaaaaaaaa",
                        PrimaryKey = "aaaaaaaaaaaaa",
                        SecondaryKey = "a",
                    },
                },
            };
            await paloAltoNetworksFirewall.SaveLogProfileAsync(logSettings: logSettings);

            Console.WriteLine($"Succeeded");
        }

        // Firewalls_saveLogProfile_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SaveLogProfile_FirewallsSaveLogProfileMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/Firewalls_saveLogProfile_MinimumSet_Gen.json
            // this example is just showing the usage of "Firewalls_SaveLogProfile" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PaloAltoNetworksFirewallResource created on azure
            // for more information of creating PaloAltoNetworksFirewallResource, please refer to the document of PaloAltoNetworksFirewallResource
            string subscriptionId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c27";
            string resourceGroupName = "firewall-rg";
            string firewallName = "firewall1";
            ResourceIdentifier paloAltoNetworksFirewallResourceId = PaloAltoNetworksFirewallResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, firewallName);
            PaloAltoNetworksFirewallResource paloAltoNetworksFirewall = client.GetPaloAltoNetworksFirewallResource(paloAltoNetworksFirewallResourceId);

            // invoke the operation
            await paloAltoNetworksFirewall.SaveLogProfileAsync();

            Console.WriteLine($"Succeeded");
        }
    }
}
