// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Samples
{
    public partial class Sample_GlobalRulestackCertificateObjectResource
    {
        // CertificateObjectGlobalRulestack_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_CertificateObjectGlobalRulestackGetMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/CertificateObjectGlobalRulestack_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "CertificateObjectGlobalRulestack_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalRulestackCertificateObjectResource created on azure
            // for more information of creating GlobalRulestackCertificateObjectResource, please refer to the document of GlobalRulestackCertificateObjectResource
            string globalRulestackName = "praval";
            string name = "armid1";
            ResourceIdentifier globalRulestackCertificateObjectResourceId = GlobalRulestackCertificateObjectResource.CreateResourceIdentifier(globalRulestackName, name);
            GlobalRulestackCertificateObjectResource globalRulestackCertificateObject = client.GetGlobalRulestackCertificateObjectResource(globalRulestackCertificateObjectResourceId);

            // invoke the operation
            GlobalRulestackCertificateObjectResource result = await globalRulestackCertificateObject.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GlobalRulestackCertificateObjectData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CertificateObjectGlobalRulestack_Get_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_CertificateObjectGlobalRulestackGetMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/CertificateObjectGlobalRulestack_Get_MinimumSet_Gen.json
            // this example is just showing the usage of "CertificateObjectGlobalRulestack_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalRulestackCertificateObjectResource created on azure
            // for more information of creating GlobalRulestackCertificateObjectResource, please refer to the document of GlobalRulestackCertificateObjectResource
            string globalRulestackName = "praval";
            string name = "armid1";
            ResourceIdentifier globalRulestackCertificateObjectResourceId = GlobalRulestackCertificateObjectResource.CreateResourceIdentifier(globalRulestackName, name);
            GlobalRulestackCertificateObjectResource globalRulestackCertificateObject = client.GetGlobalRulestackCertificateObjectResource(globalRulestackCertificateObjectResourceId);

            // invoke the operation
            GlobalRulestackCertificateObjectResource result = await globalRulestackCertificateObject.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GlobalRulestackCertificateObjectData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CertificateObjectGlobalRulestack_CreateOrUpdate_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CertificateObjectGlobalRulestackCreateOrUpdateMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/CertificateObjectGlobalRulestack_CreateOrUpdate_MaximumSet_Gen.json
            // this example is just showing the usage of "CertificateObjectGlobalRulestack_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalRulestackCertificateObjectResource created on azure
            // for more information of creating GlobalRulestackCertificateObjectResource, please refer to the document of GlobalRulestackCertificateObjectResource
            string globalRulestackName = "praval";
            string name = "armid1";
            ResourceIdentifier globalRulestackCertificateObjectResourceId = GlobalRulestackCertificateObjectResource.CreateResourceIdentifier(globalRulestackName, name);
            GlobalRulestackCertificateObjectResource globalRulestackCertificateObject = client.GetGlobalRulestackCertificateObjectResource(globalRulestackCertificateObjectResourceId);

            // invoke the operation
            GlobalRulestackCertificateObjectData data = new GlobalRulestackCertificateObjectData(FirewallBooleanType.True)
            {
                CertificateSignerResourceId = "",
                AuditComment = "comment",
                Description = "description",
                ETag = new ETag("2bf4a339-294d-4c25-b0b2-ef649e9f5c27"),
            };
            ArmOperation<GlobalRulestackCertificateObjectResource> lro = await globalRulestackCertificateObject.UpdateAsync(WaitUntil.Completed, data);
            GlobalRulestackCertificateObjectResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GlobalRulestackCertificateObjectData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CertificateObjectGlobalRulestack_CreateOrUpdate_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CertificateObjectGlobalRulestackCreateOrUpdateMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/CertificateObjectGlobalRulestack_CreateOrUpdate_MinimumSet_Gen.json
            // this example is just showing the usage of "CertificateObjectGlobalRulestack_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalRulestackCertificateObjectResource created on azure
            // for more information of creating GlobalRulestackCertificateObjectResource, please refer to the document of GlobalRulestackCertificateObjectResource
            string globalRulestackName = "praval";
            string name = "armid1";
            ResourceIdentifier globalRulestackCertificateObjectResourceId = GlobalRulestackCertificateObjectResource.CreateResourceIdentifier(globalRulestackName, name);
            GlobalRulestackCertificateObjectResource globalRulestackCertificateObject = client.GetGlobalRulestackCertificateObjectResource(globalRulestackCertificateObjectResourceId);

            // invoke the operation
            GlobalRulestackCertificateObjectData data = new GlobalRulestackCertificateObjectData(FirewallBooleanType.True);
            ArmOperation<GlobalRulestackCertificateObjectResource> lro = await globalRulestackCertificateObject.UpdateAsync(WaitUntil.Completed, data);
            GlobalRulestackCertificateObjectResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GlobalRulestackCertificateObjectData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CertificateObjectGlobalRulestack_Delete_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_CertificateObjectGlobalRulestackDeleteMaximumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/CertificateObjectGlobalRulestack_Delete_MaximumSet_Gen.json
            // this example is just showing the usage of "CertificateObjectGlobalRulestack_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalRulestackCertificateObjectResource created on azure
            // for more information of creating GlobalRulestackCertificateObjectResource, please refer to the document of GlobalRulestackCertificateObjectResource
            string globalRulestackName = "praval";
            string name = "armid1";
            ResourceIdentifier globalRulestackCertificateObjectResourceId = GlobalRulestackCertificateObjectResource.CreateResourceIdentifier(globalRulestackName, name);
            GlobalRulestackCertificateObjectResource globalRulestackCertificateObject = client.GetGlobalRulestackCertificateObjectResource(globalRulestackCertificateObjectResourceId);

            // invoke the operation
            await globalRulestackCertificateObject.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // CertificateObjectGlobalRulestack_Delete_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_CertificateObjectGlobalRulestackDeleteMinimumSetGen()
        {
            // Generated from example definition: specification/paloaltonetworks/resource-manager/PaloAltoNetworks.Cloudngfw/stable/2023-09-01/examples/CertificateObjectGlobalRulestack_Delete_MinimumSet_Gen.json
            // this example is just showing the usage of "CertificateObjectGlobalRulestack_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GlobalRulestackCertificateObjectResource created on azure
            // for more information of creating GlobalRulestackCertificateObjectResource, please refer to the document of GlobalRulestackCertificateObjectResource
            string globalRulestackName = "praval";
            string name = "armid1";
            ResourceIdentifier globalRulestackCertificateObjectResourceId = GlobalRulestackCertificateObjectResource.CreateResourceIdentifier(globalRulestackName, name);
            GlobalRulestackCertificateObjectResource globalRulestackCertificateObject = client.GetGlobalRulestackCertificateObjectResource(globalRulestackCertificateObjectResourceId);

            // invoke the operation
            await globalRulestackCertificateObject.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
