// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Orbital.Models;

namespace Azure.ResourceManager.Orbital
{
    /// <summary>
    /// A class representing the OrbitalContactProfile data model.
    /// Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
    /// </summary>
    public partial class OrbitalContactProfileData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OrbitalContactProfileData"/>. </summary>
        /// <param name="location"> The location. </param>
        public OrbitalContactProfileData(AzureLocation location) : base(location)
        {
            Links = new ChangeTrackingList<OrbitalContactProfileLink>();
        }

        /// <summary> Initializes a new instance of <see cref="OrbitalContactProfileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The current state of the resource's creation, deletion, or modification. </param>
        /// <param name="minimumViableContactDuration"> Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station. </param>
        /// <param name="minimumElevationDegrees"> Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station. </param>
        /// <param name="autoTrackingConfiguration"> Auto-tracking configuration. </param>
        /// <param name="eventHubUri"> ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub. </param>
        /// <param name="networkConfiguration"> Network configuration of customer virtual network. </param>
        /// <param name="links"> Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OrbitalContactProfileData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, OrbitalProvisioningState? provisioningState, TimeSpan? minimumViableContactDuration, float? minimumElevationDegrees, AutoTrackingConfiguration? autoTrackingConfiguration, Uri eventHubUri, ContactProfilesPropertiesNetworkConfiguration networkConfiguration, IList<OrbitalContactProfileLink> links, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ETag = etag;
            ProvisioningState = provisioningState;
            MinimumViableContactDuration = minimumViableContactDuration;
            MinimumElevationDegrees = minimumElevationDegrees;
            AutoTrackingConfiguration = autoTrackingConfiguration;
            EventHubUri = eventHubUri;
            NetworkConfiguration = networkConfiguration;
            Links = links;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OrbitalContactProfileData"/> for deserialization. </summary>
        internal OrbitalContactProfileData()
        {
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The current state of the resource's creation, deletion, or modification. </summary>
        public OrbitalProvisioningState? ProvisioningState { get; set; }
        /// <summary> Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station. </summary>
        public TimeSpan? MinimumViableContactDuration { get; set; }
        /// <summary> Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station. </summary>
        public float? MinimumElevationDegrees { get; set; }
        /// <summary> Auto-tracking configuration. </summary>
        public AutoTrackingConfiguration? AutoTrackingConfiguration { get; set; }
        /// <summary> ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub. </summary>
        public Uri EventHubUri { get; set; }
        /// <summary> Network configuration of customer virtual network. </summary>
        internal ContactProfilesPropertiesNetworkConfiguration NetworkConfiguration { get; set; }
        /// <summary> ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it. </summary>
        public ResourceIdentifier NetworkSubnetId
        {
            get => NetworkConfiguration is null ? default : NetworkConfiguration.NetworkSubnetId;
            set => NetworkConfiguration = new ContactProfilesPropertiesNetworkConfiguration(value);
        }

        /// <summary> Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints. </summary>
        public IList<OrbitalContactProfileLink> Links { get; }
    }
}
