// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Orbital
{
    /// <summary>
    /// A class representing a collection of <see cref="OrbitalContactProfileResource"/> and their operations.
    /// Each <see cref="OrbitalContactProfileResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get an <see cref="OrbitalContactProfileCollection"/> instance call the GetOrbitalContactProfiles method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class OrbitalContactProfileCollection : ArmCollection, IEnumerable<OrbitalContactProfileResource>, IAsyncEnumerable<OrbitalContactProfileResource>
    {
        private readonly ClientDiagnostics _orbitalContactProfileContactProfilesClientDiagnostics;
        private readonly ContactProfilesRestOperations _orbitalContactProfileContactProfilesRestClient;

        /// <summary> Initializes a new instance of the <see cref="OrbitalContactProfileCollection"/> class for mocking. </summary>
        protected OrbitalContactProfileCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OrbitalContactProfileCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal OrbitalContactProfileCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _orbitalContactProfileContactProfilesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Orbital", OrbitalContactProfileResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(OrbitalContactProfileResource.ResourceType, out string orbitalContactProfileContactProfilesApiVersion);
            _orbitalContactProfileContactProfilesRestClient = new ContactProfilesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, orbitalContactProfileContactProfilesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a contact profile.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="data"> The parameters to provide for the created Contact Profile. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<OrbitalContactProfileResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string contactProfileName, OrbitalContactProfileData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(contactProfileName, nameof(contactProfileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _orbitalContactProfileContactProfilesClientDiagnostics.CreateScope("OrbitalContactProfileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _orbitalContactProfileContactProfilesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, data, cancellationToken).ConfigureAwait(false);
                var operation = new OrbitalArmOperation<OrbitalContactProfileResource>(new OrbitalContactProfileOperationSource(Client), _orbitalContactProfileContactProfilesClientDiagnostics, Pipeline, _orbitalContactProfileContactProfilesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a contact profile.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="data"> The parameters to provide for the created Contact Profile. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<OrbitalContactProfileResource> CreateOrUpdate(WaitUntil waitUntil, string contactProfileName, OrbitalContactProfileData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(contactProfileName, nameof(contactProfileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _orbitalContactProfileContactProfilesClientDiagnostics.CreateScope("OrbitalContactProfileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _orbitalContactProfileContactProfilesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, data, cancellationToken);
                var operation = new OrbitalArmOperation<OrbitalContactProfileResource>(new OrbitalContactProfileOperationSource(Client), _orbitalContactProfileContactProfilesClientDiagnostics, Pipeline, _orbitalContactProfileContactProfilesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the specified contact Profile in a specified resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> is null. </exception>
        public virtual async Task<Response<OrbitalContactProfileResource>> GetAsync(string contactProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(contactProfileName, nameof(contactProfileName));

            using var scope = _orbitalContactProfileContactProfilesClientDiagnostics.CreateScope("OrbitalContactProfileCollection.Get");
            scope.Start();
            try
            {
                var response = await _orbitalContactProfileContactProfilesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OrbitalContactProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the specified contact Profile in a specified resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> is null. </exception>
        public virtual Response<OrbitalContactProfileResource> Get(string contactProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(contactProfileName, nameof(contactProfileName));

            using var scope = _orbitalContactProfileContactProfilesClientDiagnostics.CreateScope("OrbitalContactProfileCollection.Get");
            scope.Start();
            try
            {
                var response = _orbitalContactProfileContactProfilesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OrbitalContactProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns list of contact profiles by Resource Group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="skiptoken"> An opaque string that the resource provider uses to skip over previously-returned results. This is used when a previous list operation call returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OrbitalContactProfileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OrbitalContactProfileResource> GetAllAsync(string skiptoken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _orbitalContactProfileContactProfilesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, skiptoken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _orbitalContactProfileContactProfilesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, skiptoken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new OrbitalContactProfileResource(Client, OrbitalContactProfileData.DeserializeOrbitalContactProfileData(e)), _orbitalContactProfileContactProfilesClientDiagnostics, Pipeline, "OrbitalContactProfileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns list of contact profiles by Resource Group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="skiptoken"> An opaque string that the resource provider uses to skip over previously-returned results. This is used when a previous list operation call returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OrbitalContactProfileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OrbitalContactProfileResource> GetAll(string skiptoken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _orbitalContactProfileContactProfilesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, skiptoken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _orbitalContactProfileContactProfilesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, skiptoken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new OrbitalContactProfileResource(Client, OrbitalContactProfileData.DeserializeOrbitalContactProfileData(e)), _orbitalContactProfileContactProfilesClientDiagnostics, Pipeline, "OrbitalContactProfileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string contactProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(contactProfileName, nameof(contactProfileName));

            using var scope = _orbitalContactProfileContactProfilesClientDiagnostics.CreateScope("OrbitalContactProfileCollection.Exists");
            scope.Start();
            try
            {
                var response = await _orbitalContactProfileContactProfilesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> is null. </exception>
        public virtual Response<bool> Exists(string contactProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(contactProfileName, nameof(contactProfileName));

            using var scope = _orbitalContactProfileContactProfilesClientDiagnostics.CreateScope("OrbitalContactProfileCollection.Exists");
            scope.Start();
            try
            {
                var response = _orbitalContactProfileContactProfilesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> is null. </exception>
        public virtual async Task<NullableResponse<OrbitalContactProfileResource>> GetIfExistsAsync(string contactProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(contactProfileName, nameof(contactProfileName));

            using var scope = _orbitalContactProfileContactProfilesClientDiagnostics.CreateScope("OrbitalContactProfileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _orbitalContactProfileContactProfilesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<OrbitalContactProfileResource>(response.GetRawResponse());
                return Response.FromValue(new OrbitalContactProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> is null. </exception>
        public virtual NullableResponse<OrbitalContactProfileResource> GetIfExists(string contactProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(contactProfileName, nameof(contactProfileName));

            using var scope = _orbitalContactProfileContactProfilesClientDiagnostics.CreateScope("OrbitalContactProfileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _orbitalContactProfileContactProfilesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, contactProfileName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<OrbitalContactProfileResource>(response.GetRawResponse());
                return Response.FromValue(new OrbitalContactProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<OrbitalContactProfileResource> IEnumerable<OrbitalContactProfileResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<OrbitalContactProfileResource> IAsyncEnumerable<OrbitalContactProfileResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
