// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Orbital.Models
{
    /// <summary> Polarization. e.g. (RHCP, LHCP). </summary>
    public readonly partial struct OrbitalLinkPolarization : IEquatable<OrbitalLinkPolarization>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OrbitalLinkPolarization"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OrbitalLinkPolarization(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RhcpValue = "RHCP";
        private const string LhcpValue = "LHCP";
        private const string LinearVerticalValue = "linearVertical";
        private const string LinearHorizontalValue = "linearHorizontal";

        /// <summary> RHCP. </summary>
        public static OrbitalLinkPolarization Rhcp { get; } = new OrbitalLinkPolarization(RhcpValue);
        /// <summary> LHCP. </summary>
        public static OrbitalLinkPolarization Lhcp { get; } = new OrbitalLinkPolarization(LhcpValue);
        /// <summary> linearVertical. </summary>
        public static OrbitalLinkPolarization LinearVertical { get; } = new OrbitalLinkPolarization(LinearVerticalValue);
        /// <summary> linearHorizontal. </summary>
        public static OrbitalLinkPolarization LinearHorizontal { get; } = new OrbitalLinkPolarization(LinearHorizontalValue);
        /// <summary> Determines if two <see cref="OrbitalLinkPolarization"/> values are the same. </summary>
        public static bool operator ==(OrbitalLinkPolarization left, OrbitalLinkPolarization right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OrbitalLinkPolarization"/> values are not the same. </summary>
        public static bool operator !=(OrbitalLinkPolarization left, OrbitalLinkPolarization right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OrbitalLinkPolarization"/>. </summary>
        public static implicit operator OrbitalLinkPolarization(string value) => new OrbitalLinkPolarization(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OrbitalLinkPolarization other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OrbitalLinkPolarization other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
