// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Orbital.Models
{
    /// <summary> Direction (uplink or downlink). </summary>
    public readonly partial struct OrbitalLinkDirection : IEquatable<OrbitalLinkDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OrbitalLinkDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OrbitalLinkDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UplinkValue = "uplink";
        private const string DownlinkValue = "downlink";

        /// <summary> uplink. </summary>
        public static OrbitalLinkDirection Uplink { get; } = new OrbitalLinkDirection(UplinkValue);
        /// <summary> downlink. </summary>
        public static OrbitalLinkDirection Downlink { get; } = new OrbitalLinkDirection(DownlinkValue);
        /// <summary> Determines if two <see cref="OrbitalLinkDirection"/> values are the same. </summary>
        public static bool operator ==(OrbitalLinkDirection left, OrbitalLinkDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OrbitalLinkDirection"/> values are not the same. </summary>
        public static bool operator !=(OrbitalLinkDirection left, OrbitalLinkDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OrbitalLinkDirection"/>. </summary>
        public static implicit operator OrbitalLinkDirection(string value) => new OrbitalLinkDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OrbitalLinkDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OrbitalLinkDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
