// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Orbital.Models
{
    /// <summary> Status of a contact. </summary>
    public readonly partial struct OrbitalContactStatus : IEquatable<OrbitalContactStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OrbitalContactStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OrbitalContactStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScheduledValue = "scheduled";
        private const string CancelledValue = "cancelled";
        private const string SucceededValue = "succeeded";
        private const string FailedValue = "failed";
        private const string ProviderCancelledValue = "providerCancelled";

        /// <summary> scheduled. </summary>
        public static OrbitalContactStatus Scheduled { get; } = new OrbitalContactStatus(ScheduledValue);
        /// <summary> cancelled. </summary>
        public static OrbitalContactStatus Cancelled { get; } = new OrbitalContactStatus(CancelledValue);
        /// <summary> succeeded. </summary>
        public static OrbitalContactStatus Succeeded { get; } = new OrbitalContactStatus(SucceededValue);
        /// <summary> failed. </summary>
        public static OrbitalContactStatus Failed { get; } = new OrbitalContactStatus(FailedValue);
        /// <summary> providerCancelled. </summary>
        public static OrbitalContactStatus ProviderCancelled { get; } = new OrbitalContactStatus(ProviderCancelledValue);
        /// <summary> Determines if two <see cref="OrbitalContactStatus"/> values are the same. </summary>
        public static bool operator ==(OrbitalContactStatus left, OrbitalContactStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OrbitalContactStatus"/> values are not the same. </summary>
        public static bool operator !=(OrbitalContactStatus left, OrbitalContactStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OrbitalContactStatus"/>. </summary>
        public static implicit operator OrbitalContactStatus(string value) => new OrbitalContactStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OrbitalContactStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OrbitalContactStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
