// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Orbital.Models
{
    /// <summary> Protocol either UDP or TCP. </summary>
    public readonly partial struct OrbitalContactProtocol : IEquatable<OrbitalContactProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OrbitalContactProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OrbitalContactProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "TCP";
        private const string UdpValue = "UDP";

        /// <summary> TCP. </summary>
        public static OrbitalContactProtocol Tcp { get; } = new OrbitalContactProtocol(TcpValue);
        /// <summary> UDP. </summary>
        public static OrbitalContactProtocol Udp { get; } = new OrbitalContactProtocol(UdpValue);
        /// <summary> Determines if two <see cref="OrbitalContactProtocol"/> values are the same. </summary>
        public static bool operator ==(OrbitalContactProtocol left, OrbitalContactProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OrbitalContactProtocol"/> values are not the same. </summary>
        public static bool operator !=(OrbitalContactProtocol left, OrbitalContactProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OrbitalContactProtocol"/>. </summary>
        public static implicit operator OrbitalContactProtocol(string value) => new OrbitalContactProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OrbitalContactProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OrbitalContactProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
