// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Orbital.Models
{
    /// <summary> Contact Profile Link. </summary>
    public partial class OrbitalContactProfileLink
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OrbitalContactProfileLink"/>. </summary>
        /// <param name="name"> Link name. </param>
        /// <param name="polarization"> Polarization. e.g. (RHCP, LHCP). </param>
        /// <param name="direction"> Direction (uplink or downlink). </param>
        /// <param name="channels"> Contact Profile Link Channel. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="channels"/> is null. </exception>
        public OrbitalContactProfileLink(string name, OrbitalLinkPolarization polarization, OrbitalLinkDirection direction, IEnumerable<OrbitalContactProfileLinkChannel> channels)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(channels, nameof(channels));

            Name = name;
            Polarization = polarization;
            Direction = direction;
            Channels = channels.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="OrbitalContactProfileLink"/>. </summary>
        /// <param name="name"> Link name. </param>
        /// <param name="polarization"> Polarization. e.g. (RHCP, LHCP). </param>
        /// <param name="direction"> Direction (uplink or downlink). </param>
        /// <param name="gainOverTemperature"> Gain To Noise Temperature in db/K. It is the required G/T by the customer. Not used yet. </param>
        /// <param name="eirpdBW"> Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet. </param>
        /// <param name="channels"> Contact Profile Link Channel. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OrbitalContactProfileLink(string name, OrbitalLinkPolarization polarization, OrbitalLinkDirection direction, float? gainOverTemperature, float? eirpdBW, IList<OrbitalContactProfileLinkChannel> channels, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Polarization = polarization;
            Direction = direction;
            GainOverTemperature = gainOverTemperature;
            EirpdBW = eirpdBW;
            Channels = channels;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OrbitalContactProfileLink"/> for deserialization. </summary>
        internal OrbitalContactProfileLink()
        {
        }

        /// <summary> Link name. </summary>
        public string Name { get; set; }
        /// <summary> Polarization. e.g. (RHCP, LHCP). </summary>
        public OrbitalLinkPolarization Polarization { get; set; }
        /// <summary> Direction (uplink or downlink). </summary>
        public OrbitalLinkDirection Direction { get; set; }
        /// <summary> Gain To Noise Temperature in db/K. It is the required G/T by the customer. Not used yet. </summary>
        public float? GainOverTemperature { get; set; }
        /// <summary> Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet. </summary>
        public float? EirpdBW { get; set; }
        /// <summary> Contact Profile Link Channel. </summary>
        public IList<OrbitalContactProfileLinkChannel> Channels { get; }
    }
}
