// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Orbital.Models
{
    /// <summary> Parameters that define the contact resource. </summary>
    public partial class OrbitalAvailableContactsContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OrbitalAvailableContactsContent"/>. </summary>
        /// <param name="contactProfile"> The reference to the contact profile resource. </param>
        /// <param name="groundStationName"> Name of Azure Ground Station. </param>
        /// <param name="startOn"> Start time of a contact (ISO 8601 UTC standard). </param>
        /// <param name="endOn"> End time of a contact (ISO 8601 UTC standard). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfile"/> or <paramref name="groundStationName"/> is null. </exception>
        public OrbitalAvailableContactsContent(WritableSubResource contactProfile, string groundStationName, DateTimeOffset startOn, DateTimeOffset endOn)
        {
            Argument.AssertNotNull(contactProfile, nameof(contactProfile));
            Argument.AssertNotNull(groundStationName, nameof(groundStationName));

            ContactProfile = contactProfile;
            GroundStationName = groundStationName;
            StartOn = startOn;
            EndOn = endOn;
        }

        /// <summary> Initializes a new instance of <see cref="OrbitalAvailableContactsContent"/>. </summary>
        /// <param name="contactProfile"> The reference to the contact profile resource. </param>
        /// <param name="groundStationName"> Name of Azure Ground Station. </param>
        /// <param name="startOn"> Start time of a contact (ISO 8601 UTC standard). </param>
        /// <param name="endOn"> End time of a contact (ISO 8601 UTC standard). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OrbitalAvailableContactsContent(WritableSubResource contactProfile, string groundStationName, DateTimeOffset startOn, DateTimeOffset endOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContactProfile = contactProfile;
            GroundStationName = groundStationName;
            StartOn = startOn;
            EndOn = endOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OrbitalAvailableContactsContent"/> for deserialization. </summary>
        internal OrbitalAvailableContactsContent()
        {
        }

        /// <summary> The reference to the contact profile resource. </summary>
        internal WritableSubResource ContactProfile { get; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier ContactProfileId
        {
            get => ContactProfile?.Id;
        }

        /// <summary> Name of Azure Ground Station. </summary>
        public string GroundStationName { get; }
        /// <summary> Start time of a contact (ISO 8601 UTC standard). </summary>
        public DateTimeOffset StartOn { get; }
        /// <summary> End time of a contact (ISO 8601 UTC standard). </summary>
        public DateTimeOffset EndOn { get; }
    }
}
