// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Orbital.Models
{
    /// <summary> Release Status of a ground station. </summary>
    public readonly partial struct GroundStationReleaseMode : IEquatable<GroundStationReleaseMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GroundStationReleaseMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GroundStationReleaseMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PreviewValue = "Preview";
        private const string GAValue = "GA";

        /// <summary> Preview. </summary>
        public static GroundStationReleaseMode Preview { get; } = new GroundStationReleaseMode(PreviewValue);
        /// <summary> GA. </summary>
        public static GroundStationReleaseMode GA { get; } = new GroundStationReleaseMode(GAValue);
        /// <summary> Determines if two <see cref="GroundStationReleaseMode"/> values are the same. </summary>
        public static bool operator ==(GroundStationReleaseMode left, GroundStationReleaseMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GroundStationReleaseMode"/> values are not the same. </summary>
        public static bool operator !=(GroundStationReleaseMode left, GroundStationReleaseMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GroundStationReleaseMode"/>. </summary>
        public static implicit operator GroundStationReleaseMode(string value) => new GroundStationReleaseMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GroundStationReleaseMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GroundStationReleaseMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
