// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Orbital.Models
{
    /// <summary> The GroundStationCapability. </summary>
    public readonly partial struct GroundStationCapability : IEquatable<GroundStationCapability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GroundStationCapability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GroundStationCapability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EarthObservationValue = "EarthObservation";
        private const string CommunicationValue = "Communication";

        /// <summary> EarthObservation. </summary>
        public static GroundStationCapability EarthObservation { get; } = new GroundStationCapability(EarthObservationValue);
        /// <summary> Communication. </summary>
        public static GroundStationCapability Communication { get; } = new GroundStationCapability(CommunicationValue);
        /// <summary> Determines if two <see cref="GroundStationCapability"/> values are the same. </summary>
        public static bool operator ==(GroundStationCapability left, GroundStationCapability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GroundStationCapability"/> values are not the same. </summary>
        public static bool operator !=(GroundStationCapability left, GroundStationCapability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GroundStationCapability"/>. </summary>
        public static implicit operator GroundStationCapability(string value) => new GroundStationCapability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GroundStationCapability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GroundStationCapability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
