// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Orbital
{
    internal class OrbitalSpacecraftOperationSource : IOperationSource<OrbitalSpacecraftResource>
    {
        private readonly ArmClient _client;

        internal OrbitalSpacecraftOperationSource(ArmClient client)
        {
            _client = client;
        }

        OrbitalSpacecraftResource IOperationSource<OrbitalSpacecraftResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = OrbitalSpacecraftData.DeserializeOrbitalSpacecraftData(document.RootElement);
            return new OrbitalSpacecraftResource(_client, data);
        }

        async ValueTask<OrbitalSpacecraftResource> IOperationSource<OrbitalSpacecraftResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = OrbitalSpacecraftData.DeserializeOrbitalSpacecraftData(document.RootElement);
            return new OrbitalSpacecraftResource(_client, data);
        }
    }
}
