// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Orbital
{
    internal class OrbitalContactProfileOperationSource : IOperationSource<OrbitalContactProfileResource>
    {
        private readonly ArmClient _client;

        internal OrbitalContactProfileOperationSource(ArmClient client)
        {
            _client = client;
        }

        OrbitalContactProfileResource IOperationSource<OrbitalContactProfileResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = OrbitalContactProfileData.DeserializeOrbitalContactProfileData(document.RootElement);
            return new OrbitalContactProfileResource(_client, data);
        }

        async ValueTask<OrbitalContactProfileResource> IOperationSource<OrbitalContactProfileResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = OrbitalContactProfileData.DeserializeOrbitalContactProfileData(document.RootElement);
            return new OrbitalContactProfileResource(_client, data);
        }
    }
}
