// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Orbital
{
    internal class OrbitalContactOperationSource : IOperationSource<OrbitalContactResource>
    {
        private readonly ArmClient _client;

        internal OrbitalContactOperationSource(ArmClient client)
        {
            _client = client;
        }

        OrbitalContactResource IOperationSource<OrbitalContactResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = OrbitalContactData.DeserializeOrbitalContactData(document.RootElement);
            return new OrbitalContactResource(_client, data);
        }

        async ValueTask<OrbitalContactResource> IOperationSource<OrbitalContactResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = OrbitalContactData.DeserializeOrbitalContactData(document.RootElement);
            return new OrbitalContactResource(_client, data);
        }
    }
}
