// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Orbital.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableOrbitalResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableOrbitalResourceGroupResource"/> class for mocking. </summary>
        protected MockableOrbitalResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableOrbitalResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableOrbitalResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of OrbitalSpacecraftResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of OrbitalSpacecraftResources and their operations over a OrbitalSpacecraftResource. </returns>
        public virtual OrbitalSpacecraftCollection GetOrbitalSpacecrafts()
        {
            return GetCachedClient(client => new OrbitalSpacecraftCollection(client, Id));
        }

        /// <summary>
        /// Gets the specified spacecraft in a specified resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/spacecrafts/{spacecraftName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Spacecrafts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalSpacecraftResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="spacecraftName"> Spacecraft ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="spacecraftName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="spacecraftName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<OrbitalSpacecraftResource>> GetOrbitalSpacecraftAsync(string spacecraftName, CancellationToken cancellationToken = default)
        {
            return await GetOrbitalSpacecrafts().GetAsync(spacecraftName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets the specified spacecraft in a specified resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/spacecrafts/{spacecraftName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Spacecrafts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalSpacecraftResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="spacecraftName"> Spacecraft ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="spacecraftName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="spacecraftName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<OrbitalSpacecraftResource> GetOrbitalSpacecraft(string spacecraftName, CancellationToken cancellationToken = default)
        {
            return GetOrbitalSpacecrafts().Get(spacecraftName, cancellationToken);
        }

        /// <summary> Gets a collection of OrbitalContactProfileResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of OrbitalContactProfileResources and their operations over a OrbitalContactProfileResource. </returns>
        public virtual OrbitalContactProfileCollection GetOrbitalContactProfiles()
        {
            return GetCachedClient(client => new OrbitalContactProfileCollection(client, Id));
        }

        /// <summary>
        /// Gets the specified contact Profile in a specified resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<OrbitalContactProfileResource>> GetOrbitalContactProfileAsync(string contactProfileName, CancellationToken cancellationToken = default)
        {
            return await GetOrbitalContactProfiles().GetAsync(contactProfileName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets the specified contact Profile in a specified resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContactProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OrbitalContactProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="contactProfileName"> Contact Profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="contactProfileName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="contactProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<OrbitalContactProfileResource> GetOrbitalContactProfile(string contactProfileName, CancellationToken cancellationToken = default)
        {
            return GetOrbitalContactProfiles().Get(contactProfileName, cancellationToken);
        }
    }
}
