// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Orbital.Models;

namespace Azure.ResourceManager.Orbital
{
    /// <summary>
    /// A class representing the AvailableGroundStation data model.
    /// Ground Stations available to schedule Contacts.
    /// </summary>
    public partial class AvailableGroundStationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvailableGroundStationData"/>. </summary>
        internal AvailableGroundStationData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AvailableGroundStationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Azure region. </param>
        /// <param name="city"> City of ground station. </param>
        /// <param name="providerName"> Ground station provider name. </param>
        /// <param name="longitudeDegrees"> Longitude of the ground station in decimal degrees. </param>
        /// <param name="latitudeDegrees"> Latitude of the ground station in decimal degrees. </param>
        /// <param name="altitudeMeters"> Altitude of the ground station. </param>
        /// <param name="releaseMode"> Release Status of a ground station. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvailableGroundStationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AzureLocation? location, string city, string providerName, float? longitudeDegrees, float? latitudeDegrees, float? altitudeMeters, GroundStationReleaseMode? releaseMode, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Location = location;
            City = city;
            ProviderName = providerName;
            LongitudeDegrees = longitudeDegrees;
            LatitudeDegrees = latitudeDegrees;
            AltitudeMeters = altitudeMeters;
            ReleaseMode = releaseMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Azure region. </summary>
        public AzureLocation? Location { get; }
        /// <summary> City of ground station. </summary>
        public string City { get; }
        /// <summary> Ground station provider name. </summary>
        public string ProviderName { get; }
        /// <summary> Longitude of the ground station in decimal degrees. </summary>
        public float? LongitudeDegrees { get; }
        /// <summary> Latitude of the ground station in decimal degrees. </summary>
        public float? LatitudeDegrees { get; }
        /// <summary> Altitude of the ground station. </summary>
        public float? AltitudeMeters { get; }
        /// <summary> Release Status of a ground station. </summary>
        public GroundStationReleaseMode? ReleaseMode { get; }
    }
}
