// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Orbital.Samples
{
    public partial class Sample_AvailableGroundStationResource
    {
        // Get GroundStation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetGroundStation()
        {
            // Generated from example definition: specification/orbital/resource-manager/Microsoft.Orbital/stable/2022-03-01/examples/AvailableGroundStationGet.json
            // this example is just showing the usage of "AvailableGroundStations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AvailableGroundStationResource created on azure
            // for more information of creating AvailableGroundStationResource, please refer to the document of AvailableGroundStationResource
            string subscriptionId = "c1be1141-a7c9-4aac-9608-3c2e2f1152c3";
            string groundStationName = "EASTUS2_0";
            ResourceIdentifier availableGroundStationResourceId = AvailableGroundStationResource.CreateResourceIdentifier(subscriptionId, groundStationName);
            AvailableGroundStationResource availableGroundStation = client.GetAvailableGroundStationResource(availableGroundStationResourceId);

            // invoke the operation
            AvailableGroundStationResource result = await availableGroundStation.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AvailableGroundStationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
