// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="OracleSystemVersionResource"/> and their operations.
    /// Each <see cref="OracleSystemVersionResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get an <see cref="OracleSystemVersionCollection"/> instance call the GetOracleSystemVersions method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class OracleSystemVersionCollection : ArmCollection, IEnumerable<OracleSystemVersionResource>, IAsyncEnumerable<OracleSystemVersionResource>
    {
        private readonly ClientDiagnostics _oracleSystemVersionSystemVersionsClientDiagnostics;
        private readonly SystemVersionsRestOperations _oracleSystemVersionSystemVersionsRestClient;
        private readonly AzureLocation _location;

        /// <summary> Initializes a new instance of the <see cref="OracleSystemVersionCollection"/> class for mocking. </summary>
        protected OracleSystemVersionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OracleSystemVersionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="location"> The name of the Azure region. </param>
        internal OracleSystemVersionCollection(ArmClient client, ResourceIdentifier id, AzureLocation location) : base(client, id)
        {
            _location = location;
            _oracleSystemVersionSystemVersionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", OracleSystemVersionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(OracleSystemVersionResource.ResourceType, out string oracleSystemVersionSystemVersionsApiVersion);
            _oracleSystemVersionSystemVersionsRestClient = new SystemVersionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, oracleSystemVersionSystemVersionsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a SystemVersion
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/systemVersions/{systemversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleSystemVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="systemversionname"> SystemVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="systemversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="systemversionname"/> is null. </exception>
        public virtual async Task<Response<OracleSystemVersionResource>> GetAsync(string systemversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(systemversionname, nameof(systemversionname));

            using var scope = _oracleSystemVersionSystemVersionsClientDiagnostics.CreateScope("OracleSystemVersionCollection.Get");
            scope.Start();
            try
            {
                var response = await _oracleSystemVersionSystemVersionsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), systemversionname, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleSystemVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a SystemVersion
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/systemVersions/{systemversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleSystemVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="systemversionname"> SystemVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="systemversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="systemversionname"/> is null. </exception>
        public virtual Response<OracleSystemVersionResource> Get(string systemversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(systemversionname, nameof(systemversionname));

            using var scope = _oracleSystemVersionSystemVersionsClientDiagnostics.CreateScope("OracleSystemVersionCollection.Get");
            scope.Start();
            try
            {
                var response = _oracleSystemVersionSystemVersionsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), systemversionname, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleSystemVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List SystemVersion resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/systemVersions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemVersions_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleSystemVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OracleSystemVersionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OracleSystemVersionResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleSystemVersionSystemVersionsRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleSystemVersionSystemVersionsRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new OracleSystemVersionResource(Client, OracleSystemVersionData.DeserializeOracleSystemVersionData(e)), _oracleSystemVersionSystemVersionsClientDiagnostics, Pipeline, "OracleSystemVersionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List SystemVersion resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/systemVersions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemVersions_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleSystemVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OracleSystemVersionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OracleSystemVersionResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleSystemVersionSystemVersionsRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleSystemVersionSystemVersionsRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new OracleSystemVersionResource(Client, OracleSystemVersionData.DeserializeOracleSystemVersionData(e)), _oracleSystemVersionSystemVersionsClientDiagnostics, Pipeline, "OracleSystemVersionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/systemVersions/{systemversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleSystemVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="systemversionname"> SystemVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="systemversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="systemversionname"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string systemversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(systemversionname, nameof(systemversionname));

            using var scope = _oracleSystemVersionSystemVersionsClientDiagnostics.CreateScope("OracleSystemVersionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _oracleSystemVersionSystemVersionsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), systemversionname, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/systemVersions/{systemversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleSystemVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="systemversionname"> SystemVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="systemversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="systemversionname"/> is null. </exception>
        public virtual Response<bool> Exists(string systemversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(systemversionname, nameof(systemversionname));

            using var scope = _oracleSystemVersionSystemVersionsClientDiagnostics.CreateScope("OracleSystemVersionCollection.Exists");
            scope.Start();
            try
            {
                var response = _oracleSystemVersionSystemVersionsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), systemversionname, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/systemVersions/{systemversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleSystemVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="systemversionname"> SystemVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="systemversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="systemversionname"/> is null. </exception>
        public virtual async Task<NullableResponse<OracleSystemVersionResource>> GetIfExistsAsync(string systemversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(systemversionname, nameof(systemversionname));

            using var scope = _oracleSystemVersionSystemVersionsClientDiagnostics.CreateScope("OracleSystemVersionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _oracleSystemVersionSystemVersionsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), systemversionname, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<OracleSystemVersionResource>(response.GetRawResponse());
                return Response.FromValue(new OracleSystemVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/systemVersions/{systemversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SystemVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleSystemVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="systemversionname"> SystemVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="systemversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="systemversionname"/> is null. </exception>
        public virtual NullableResponse<OracleSystemVersionResource> GetIfExists(string systemversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(systemversionname, nameof(systemversionname));

            using var scope = _oracleSystemVersionSystemVersionsClientDiagnostics.CreateScope("OracleSystemVersionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _oracleSystemVersionSystemVersionsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), systemversionname, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<OracleSystemVersionResource>(response.GetRawResponse());
                return Response.FromValue(new OracleSystemVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<OracleSystemVersionResource> IEnumerable<OracleSystemVersionResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<OracleSystemVersionResource> IAsyncEnumerable<OracleSystemVersionResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
