// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="OracleGIVersionResource"/> and their operations.
    /// Each <see cref="OracleGIVersionResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get an <see cref="OracleGIVersionCollection"/> instance call the GetOracleGIVersions method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class OracleGIVersionCollection : ArmCollection, IEnumerable<OracleGIVersionResource>, IAsyncEnumerable<OracleGIVersionResource>
    {
        private readonly ClientDiagnostics _oracleGIVersionGiVersionsClientDiagnostics;
        private readonly GiVersionsRestOperations _oracleGIVersionGiVersionsRestClient;
        private readonly AzureLocation _location;

        /// <summary> Initializes a new instance of the <see cref="OracleGIVersionCollection"/> class for mocking. </summary>
        protected OracleGIVersionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OracleGIVersionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="location"> The name of the Azure region. </param>
        internal OracleGIVersionCollection(ArmClient client, ResourceIdentifier id, AzureLocation location) : base(client, id)
        {
            _location = location;
            _oracleGIVersionGiVersionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", OracleGIVersionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(OracleGIVersionResource.ResourceType, out string oracleGIVersionGiVersionsApiVersion);
            _oracleGIVersionGiVersionsRestClient = new GiVersionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, oracleGIVersionGiVersionsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a GiVersion
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/giVersions/{giversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GiVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleGIVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="giversionname"> GiVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="giversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="giversionname"/> is null. </exception>
        public virtual async Task<Response<OracleGIVersionResource>> GetAsync(string giversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(giversionname, nameof(giversionname));

            using var scope = _oracleGIVersionGiVersionsClientDiagnostics.CreateScope("OracleGIVersionCollection.Get");
            scope.Start();
            try
            {
                var response = await _oracleGIVersionGiVersionsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), giversionname, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleGIVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a GiVersion
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/giVersions/{giversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GiVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleGIVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="giversionname"> GiVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="giversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="giversionname"/> is null. </exception>
        public virtual Response<OracleGIVersionResource> Get(string giversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(giversionname, nameof(giversionname));

            using var scope = _oracleGIVersionGiVersionsClientDiagnostics.CreateScope("OracleGIVersionCollection.Get");
            scope.Start();
            try
            {
                var response = _oracleGIVersionGiVersionsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), giversionname, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleGIVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List GiVersion resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/giVersions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GiVersions_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleGIVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OracleGIVersionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OracleGIVersionResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleGIVersionGiVersionsRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleGIVersionGiVersionsRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new OracleGIVersionResource(Client, OracleGIVersionData.DeserializeOracleGIVersionData(e)), _oracleGIVersionGiVersionsClientDiagnostics, Pipeline, "OracleGIVersionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List GiVersion resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/giVersions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GiVersions_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleGIVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OracleGIVersionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OracleGIVersionResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleGIVersionGiVersionsRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleGIVersionGiVersionsRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new OracleGIVersionResource(Client, OracleGIVersionData.DeserializeOracleGIVersionData(e)), _oracleGIVersionGiVersionsClientDiagnostics, Pipeline, "OracleGIVersionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/giVersions/{giversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GiVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleGIVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="giversionname"> GiVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="giversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="giversionname"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string giversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(giversionname, nameof(giversionname));

            using var scope = _oracleGIVersionGiVersionsClientDiagnostics.CreateScope("OracleGIVersionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _oracleGIVersionGiVersionsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), giversionname, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/giVersions/{giversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GiVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleGIVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="giversionname"> GiVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="giversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="giversionname"/> is null. </exception>
        public virtual Response<bool> Exists(string giversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(giversionname, nameof(giversionname));

            using var scope = _oracleGIVersionGiVersionsClientDiagnostics.CreateScope("OracleGIVersionCollection.Exists");
            scope.Start();
            try
            {
                var response = _oracleGIVersionGiVersionsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), giversionname, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/giVersions/{giversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GiVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleGIVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="giversionname"> GiVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="giversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="giversionname"/> is null. </exception>
        public virtual async Task<NullableResponse<OracleGIVersionResource>> GetIfExistsAsync(string giversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(giversionname, nameof(giversionname));

            using var scope = _oracleGIVersionGiVersionsClientDiagnostics.CreateScope("OracleGIVersionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _oracleGIVersionGiVersionsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), giversionname, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<OracleGIVersionResource>(response.GetRawResponse());
                return Response.FromValue(new OracleGIVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/giVersions/{giversionname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GiVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleGIVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="giversionname"> GiVersion name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="giversionname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="giversionname"/> is null. </exception>
        public virtual NullableResponse<OracleGIVersionResource> GetIfExists(string giversionname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(giversionname, nameof(giversionname));

            using var scope = _oracleGIVersionGiVersionsClientDiagnostics.CreateScope("OracleGIVersionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _oracleGIVersionGiVersionsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), giversionname, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<OracleGIVersionResource>(response.GetRawResponse());
                return Response.FromValue(new OracleGIVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<OracleGIVersionResource> IEnumerable<OracleGIVersionResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<OracleGIVersionResource> IAsyncEnumerable<OracleGIVersionResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
