// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="OracleDnsPrivateZoneResource"/> and their operations.
    /// Each <see cref="OracleDnsPrivateZoneResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get an <see cref="OracleDnsPrivateZoneCollection"/> instance call the GetOracleDnsPrivateZones method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class OracleDnsPrivateZoneCollection : ArmCollection, IEnumerable<OracleDnsPrivateZoneResource>, IAsyncEnumerable<OracleDnsPrivateZoneResource>
    {
        private readonly ClientDiagnostics _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics;
        private readonly DnsPrivateZonesRestOperations _oracleDnsPrivateZoneDnsPrivateZonesRestClient;
        private readonly AzureLocation _location;

        /// <summary> Initializes a new instance of the <see cref="OracleDnsPrivateZoneCollection"/> class for mocking. </summary>
        protected OracleDnsPrivateZoneCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OracleDnsPrivateZoneCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="location"> The name of the Azure region. </param>
        internal OracleDnsPrivateZoneCollection(ArmClient client, ResourceIdentifier id, AzureLocation location) : base(client, id)
        {
            _location = location;
            _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", OracleDnsPrivateZoneResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(OracleDnsPrivateZoneResource.ResourceType, out string oracleDnsPrivateZoneDnsPrivateZonesApiVersion);
            _oracleDnsPrivateZoneDnsPrivateZonesRestClient = new DnsPrivateZonesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, oracleDnsPrivateZoneDnsPrivateZonesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a DnsPrivateZone
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateZones/{dnsprivatezonename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivatezonename"> DnsPrivateZone name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivatezonename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivatezonename"/> is null. </exception>
        public virtual async Task<Response<OracleDnsPrivateZoneResource>> GetAsync(string dnsprivatezonename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivatezonename, nameof(dnsprivatezonename));

            using var scope = _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics.CreateScope("OracleDnsPrivateZoneCollection.Get");
            scope.Start();
            try
            {
                var response = await _oracleDnsPrivateZoneDnsPrivateZonesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dnsprivatezonename, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDnsPrivateZoneResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a DnsPrivateZone
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateZones/{dnsprivatezonename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivatezonename"> DnsPrivateZone name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivatezonename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivatezonename"/> is null. </exception>
        public virtual Response<OracleDnsPrivateZoneResource> Get(string dnsprivatezonename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivatezonename, nameof(dnsprivatezonename));

            using var scope = _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics.CreateScope("OracleDnsPrivateZoneCollection.Get");
            scope.Start();
            try
            {
                var response = _oracleDnsPrivateZoneDnsPrivateZonesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dnsprivatezonename, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDnsPrivateZoneResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List DnsPrivateZone resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateZones</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateZones_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OracleDnsPrivateZoneResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OracleDnsPrivateZoneResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleDnsPrivateZoneDnsPrivateZonesRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleDnsPrivateZoneDnsPrivateZonesRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new OracleDnsPrivateZoneResource(Client, OracleDnsPrivateZoneData.DeserializeOracleDnsPrivateZoneData(e)), _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics, Pipeline, "OracleDnsPrivateZoneCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List DnsPrivateZone resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateZones</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateZones_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OracleDnsPrivateZoneResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OracleDnsPrivateZoneResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleDnsPrivateZoneDnsPrivateZonesRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleDnsPrivateZoneDnsPrivateZonesRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new OracleDnsPrivateZoneResource(Client, OracleDnsPrivateZoneData.DeserializeOracleDnsPrivateZoneData(e)), _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics, Pipeline, "OracleDnsPrivateZoneCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateZones/{dnsprivatezonename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivatezonename"> DnsPrivateZone name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivatezonename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivatezonename"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string dnsprivatezonename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivatezonename, nameof(dnsprivatezonename));

            using var scope = _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics.CreateScope("OracleDnsPrivateZoneCollection.Exists");
            scope.Start();
            try
            {
                var response = await _oracleDnsPrivateZoneDnsPrivateZonesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dnsprivatezonename, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateZones/{dnsprivatezonename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivatezonename"> DnsPrivateZone name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivatezonename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivatezonename"/> is null. </exception>
        public virtual Response<bool> Exists(string dnsprivatezonename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivatezonename, nameof(dnsprivatezonename));

            using var scope = _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics.CreateScope("OracleDnsPrivateZoneCollection.Exists");
            scope.Start();
            try
            {
                var response = _oracleDnsPrivateZoneDnsPrivateZonesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dnsprivatezonename, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateZones/{dnsprivatezonename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivatezonename"> DnsPrivateZone name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivatezonename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivatezonename"/> is null. </exception>
        public virtual async Task<NullableResponse<OracleDnsPrivateZoneResource>> GetIfExistsAsync(string dnsprivatezonename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivatezonename, nameof(dnsprivatezonename));

            using var scope = _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics.CreateScope("OracleDnsPrivateZoneCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _oracleDnsPrivateZoneDnsPrivateZonesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dnsprivatezonename, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<OracleDnsPrivateZoneResource>(response.GetRawResponse());
                return Response.FromValue(new OracleDnsPrivateZoneResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateZones/{dnsprivatezonename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivatezonename"> DnsPrivateZone name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivatezonename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivatezonename"/> is null. </exception>
        public virtual NullableResponse<OracleDnsPrivateZoneResource> GetIfExists(string dnsprivatezonename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivatezonename, nameof(dnsprivatezonename));

            using var scope = _oracleDnsPrivateZoneDnsPrivateZonesClientDiagnostics.CreateScope("OracleDnsPrivateZoneCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _oracleDnsPrivateZoneDnsPrivateZonesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dnsprivatezonename, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<OracleDnsPrivateZoneResource>(response.GetRawResponse());
                return Response.FromValue(new OracleDnsPrivateZoneResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<OracleDnsPrivateZoneResource> IEnumerable<OracleDnsPrivateZoneResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<OracleDnsPrivateZoneResource> IAsyncEnumerable<OracleDnsPrivateZoneResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
