// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="OracleDnsPrivateViewResource"/> and their operations.
    /// Each <see cref="OracleDnsPrivateViewResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get an <see cref="OracleDnsPrivateViewCollection"/> instance call the GetOracleDnsPrivateViews method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class OracleDnsPrivateViewCollection : ArmCollection, IEnumerable<OracleDnsPrivateViewResource>, IAsyncEnumerable<OracleDnsPrivateViewResource>
    {
        private readonly ClientDiagnostics _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics;
        private readonly DnsPrivateViewsRestOperations _oracleDnsPrivateViewDnsPrivateViewsRestClient;
        private readonly AzureLocation _location;

        /// <summary> Initializes a new instance of the <see cref="OracleDnsPrivateViewCollection"/> class for mocking. </summary>
        protected OracleDnsPrivateViewCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OracleDnsPrivateViewCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="location"> The name of the Azure region. </param>
        internal OracleDnsPrivateViewCollection(ArmClient client, ResourceIdentifier id, AzureLocation location) : base(client, id)
        {
            _location = location;
            _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", OracleDnsPrivateViewResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(OracleDnsPrivateViewResource.ResourceType, out string oracleDnsPrivateViewDnsPrivateViewsApiVersion);
            _oracleDnsPrivateViewDnsPrivateViewsRestClient = new DnsPrivateViewsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, oracleDnsPrivateViewDnsPrivateViewsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a DnsPrivateView
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateViews/{dnsprivateviewocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateViews_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateViewResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivateviewocid"> DnsPrivateView OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivateviewocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivateviewocid"/> is null. </exception>
        public virtual async Task<Response<OracleDnsPrivateViewResource>> GetAsync(string dnsprivateviewocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivateviewocid, nameof(dnsprivateviewocid));

            using var scope = _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics.CreateScope("OracleDnsPrivateViewCollection.Get");
            scope.Start();
            try
            {
                var response = await _oracleDnsPrivateViewDnsPrivateViewsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dnsprivateviewocid, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDnsPrivateViewResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a DnsPrivateView
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateViews/{dnsprivateviewocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateViews_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateViewResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivateviewocid"> DnsPrivateView OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivateviewocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivateviewocid"/> is null. </exception>
        public virtual Response<OracleDnsPrivateViewResource> Get(string dnsprivateviewocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivateviewocid, nameof(dnsprivateviewocid));

            using var scope = _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics.CreateScope("OracleDnsPrivateViewCollection.Get");
            scope.Start();
            try
            {
                var response = _oracleDnsPrivateViewDnsPrivateViewsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dnsprivateviewocid, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDnsPrivateViewResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List DnsPrivateView resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateViews</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateViews_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateViewResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OracleDnsPrivateViewResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OracleDnsPrivateViewResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleDnsPrivateViewDnsPrivateViewsRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleDnsPrivateViewDnsPrivateViewsRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new OracleDnsPrivateViewResource(Client, OracleDnsPrivateViewData.DeserializeOracleDnsPrivateViewData(e)), _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics, Pipeline, "OracleDnsPrivateViewCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List DnsPrivateView resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateViews</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateViews_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateViewResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OracleDnsPrivateViewResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OracleDnsPrivateViewResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleDnsPrivateViewDnsPrivateViewsRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleDnsPrivateViewDnsPrivateViewsRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new OracleDnsPrivateViewResource(Client, OracleDnsPrivateViewData.DeserializeOracleDnsPrivateViewData(e)), _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics, Pipeline, "OracleDnsPrivateViewCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateViews/{dnsprivateviewocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateViews_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateViewResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivateviewocid"> DnsPrivateView OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivateviewocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivateviewocid"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string dnsprivateviewocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivateviewocid, nameof(dnsprivateviewocid));

            using var scope = _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics.CreateScope("OracleDnsPrivateViewCollection.Exists");
            scope.Start();
            try
            {
                var response = await _oracleDnsPrivateViewDnsPrivateViewsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dnsprivateviewocid, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateViews/{dnsprivateviewocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateViews_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateViewResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivateviewocid"> DnsPrivateView OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivateviewocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivateviewocid"/> is null. </exception>
        public virtual Response<bool> Exists(string dnsprivateviewocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivateviewocid, nameof(dnsprivateviewocid));

            using var scope = _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics.CreateScope("OracleDnsPrivateViewCollection.Exists");
            scope.Start();
            try
            {
                var response = _oracleDnsPrivateViewDnsPrivateViewsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dnsprivateviewocid, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateViews/{dnsprivateviewocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateViews_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateViewResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivateviewocid"> DnsPrivateView OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivateviewocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivateviewocid"/> is null. </exception>
        public virtual async Task<NullableResponse<OracleDnsPrivateViewResource>> GetIfExistsAsync(string dnsprivateviewocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivateviewocid, nameof(dnsprivateviewocid));

            using var scope = _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics.CreateScope("OracleDnsPrivateViewCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _oracleDnsPrivateViewDnsPrivateViewsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dnsprivateviewocid, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<OracleDnsPrivateViewResource>(response.GetRawResponse());
                return Response.FromValue(new OracleDnsPrivateViewResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dnsPrivateViews/{dnsprivateviewocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsPrivateViews_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDnsPrivateViewResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsprivateviewocid"> DnsPrivateView OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsprivateviewocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsprivateviewocid"/> is null. </exception>
        public virtual NullableResponse<OracleDnsPrivateViewResource> GetIfExists(string dnsprivateviewocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsprivateviewocid, nameof(dnsprivateviewocid));

            using var scope = _oracleDnsPrivateViewDnsPrivateViewsClientDiagnostics.CreateScope("OracleDnsPrivateViewCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _oracleDnsPrivateViewDnsPrivateViewsRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dnsprivateviewocid, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<OracleDnsPrivateViewResource>(response.GetRawResponse());
                return Response.FromValue(new OracleDnsPrivateViewResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<OracleDnsPrivateViewResource> IEnumerable<OracleDnsPrivateViewResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<OracleDnsPrivateViewResource> IAsyncEnumerable<OracleDnsPrivateViewResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
