// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="OracleDBSystemShapeResource"/> and their operations.
    /// Each <see cref="OracleDBSystemShapeResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get an <see cref="OracleDBSystemShapeCollection"/> instance call the GetOracleDBSystemShapes method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class OracleDBSystemShapeCollection : ArmCollection, IEnumerable<OracleDBSystemShapeResource>, IAsyncEnumerable<OracleDBSystemShapeResource>
    {
        private readonly ClientDiagnostics _oracleDBSystemShapeDBSystemShapesClientDiagnostics;
        private readonly DbSystemShapesRestOperations _oracleDBSystemShapeDBSystemShapesRestClient;
        private readonly AzureLocation _location;

        /// <summary> Initializes a new instance of the <see cref="OracleDBSystemShapeCollection"/> class for mocking. </summary>
        protected OracleDBSystemShapeCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OracleDBSystemShapeCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="location"> The name of the Azure region. </param>
        internal OracleDBSystemShapeCollection(ArmClient client, ResourceIdentifier id, AzureLocation location) : base(client, id)
        {
            _location = location;
            _oracleDBSystemShapeDBSystemShapesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", OracleDBSystemShapeResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(OracleDBSystemShapeResource.ResourceType, out string oracleDBSystemShapeDBSystemShapesApiVersion);
            _oracleDBSystemShapeDBSystemShapesRestClient = new DbSystemShapesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, oracleDBSystemShapeDBSystemShapesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a DbSystemShape
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dbSystemShapes/{dbsystemshapename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbSystemShapes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBSystemShapeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbsystemshapename"> DbSystemShape name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbsystemshapename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbsystemshapename"/> is null. </exception>
        public virtual async Task<Response<OracleDBSystemShapeResource>> GetAsync(string dbsystemshapename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbsystemshapename, nameof(dbsystemshapename));

            using var scope = _oracleDBSystemShapeDBSystemShapesClientDiagnostics.CreateScope("OracleDBSystemShapeCollection.Get");
            scope.Start();
            try
            {
                var response = await _oracleDBSystemShapeDBSystemShapesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dbsystemshapename, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDBSystemShapeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a DbSystemShape
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dbSystemShapes/{dbsystemshapename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbSystemShapes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBSystemShapeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbsystemshapename"> DbSystemShape name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbsystemshapename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbsystemshapename"/> is null. </exception>
        public virtual Response<OracleDBSystemShapeResource> Get(string dbsystemshapename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbsystemshapename, nameof(dbsystemshapename));

            using var scope = _oracleDBSystemShapeDBSystemShapesClientDiagnostics.CreateScope("OracleDBSystemShapeCollection.Get");
            scope.Start();
            try
            {
                var response = _oracleDBSystemShapeDBSystemShapesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dbsystemshapename, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDBSystemShapeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List DbSystemShape resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dbSystemShapes</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbSystemShapes_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBSystemShapeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OracleDBSystemShapeResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OracleDBSystemShapeResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleDBSystemShapeDBSystemShapesRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleDBSystemShapeDBSystemShapesRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new OracleDBSystemShapeResource(Client, OracleDBSystemShapeData.DeserializeOracleDBSystemShapeData(e)), _oracleDBSystemShapeDBSystemShapesClientDiagnostics, Pipeline, "OracleDBSystemShapeCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List DbSystemShape resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dbSystemShapes</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbSystemShapes_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBSystemShapeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OracleDBSystemShapeResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OracleDBSystemShapeResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleDBSystemShapeDBSystemShapesRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleDBSystemShapeDBSystemShapesRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new OracleDBSystemShapeResource(Client, OracleDBSystemShapeData.DeserializeOracleDBSystemShapeData(e)), _oracleDBSystemShapeDBSystemShapesClientDiagnostics, Pipeline, "OracleDBSystemShapeCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dbSystemShapes/{dbsystemshapename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbSystemShapes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBSystemShapeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbsystemshapename"> DbSystemShape name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbsystemshapename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbsystemshapename"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string dbsystemshapename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbsystemshapename, nameof(dbsystemshapename));

            using var scope = _oracleDBSystemShapeDBSystemShapesClientDiagnostics.CreateScope("OracleDBSystemShapeCollection.Exists");
            scope.Start();
            try
            {
                var response = await _oracleDBSystemShapeDBSystemShapesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dbsystemshapename, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dbSystemShapes/{dbsystemshapename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbSystemShapes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBSystemShapeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbsystemshapename"> DbSystemShape name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbsystemshapename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbsystemshapename"/> is null. </exception>
        public virtual Response<bool> Exists(string dbsystemshapename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbsystemshapename, nameof(dbsystemshapename));

            using var scope = _oracleDBSystemShapeDBSystemShapesClientDiagnostics.CreateScope("OracleDBSystemShapeCollection.Exists");
            scope.Start();
            try
            {
                var response = _oracleDBSystemShapeDBSystemShapesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dbsystemshapename, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dbSystemShapes/{dbsystemshapename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbSystemShapes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBSystemShapeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbsystemshapename"> DbSystemShape name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbsystemshapename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbsystemshapename"/> is null. </exception>
        public virtual async Task<NullableResponse<OracleDBSystemShapeResource>> GetIfExistsAsync(string dbsystemshapename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbsystemshapename, nameof(dbsystemshapename));

            using var scope = _oracleDBSystemShapeDBSystemShapesClientDiagnostics.CreateScope("OracleDBSystemShapeCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _oracleDBSystemShapeDBSystemShapesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), dbsystemshapename, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<OracleDBSystemShapeResource>(response.GetRawResponse());
                return Response.FromValue(new OracleDBSystemShapeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/dbSystemShapes/{dbsystemshapename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbSystemShapes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBSystemShapeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbsystemshapename"> DbSystemShape name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbsystemshapename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbsystemshapename"/> is null. </exception>
        public virtual NullableResponse<OracleDBSystemShapeResource> GetIfExists(string dbsystemshapename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbsystemshapename, nameof(dbsystemshapename));

            using var scope = _oracleDBSystemShapeDBSystemShapesClientDiagnostics.CreateScope("OracleDBSystemShapeCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _oracleDBSystemShapeDBSystemShapesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), dbsystemshapename, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<OracleDBSystemShapeResource>(response.GetRawResponse());
                return Response.FromValue(new OracleDBSystemShapeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<OracleDBSystemShapeResource> IEnumerable<OracleDBSystemShapeResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<OracleDBSystemShapeResource> IAsyncEnumerable<OracleDBSystemShapeResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
