// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A Class representing an OracleDBServer along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="OracleDBServerResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetOracleDBServerResource method.
    /// Otherwise you can get one from its parent resource <see cref="CloudExadataInfrastructureResource"/> using the GetOracleDBServer method.
    /// </summary>
    public partial class OracleDBServerResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="OracleDBServerResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="cloudexadatainfrastructurename"> The cloudexadatainfrastructurename. </param>
        /// <param name="dbserverocid"> The dbserverocid. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string cloudexadatainfrastructurename, string dbserverocid)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _oracleDBServerDBServersClientDiagnostics;
        private readonly DbServersRestOperations _oracleDBServerDBServersRestClient;
        private readonly OracleDBServerData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Oracle.Database/cloudExadataInfrastructures/dbServers";

        /// <summary> Initializes a new instance of the <see cref="OracleDBServerResource"/> class for mocking. </summary>
        protected OracleDBServerResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OracleDBServerResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal OracleDBServerResource(ArmClient client, OracleDBServerData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="OracleDBServerResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal OracleDBServerResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _oracleDBServerDBServersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string oracleDBServerDBServersApiVersion);
            _oracleDBServerDBServersRestClient = new DbServersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, oracleDBServerDBServersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual OracleDBServerData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a DbServer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<OracleDBServerResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _oracleDBServerDBServersClientDiagnostics.CreateScope("OracleDBServerResource.Get");
            scope.Start();
            try
            {
                var response = await _oracleDBServerDBServersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDBServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a DbServer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<OracleDBServerResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _oracleDBServerDBServersClientDiagnostics.CreateScope("OracleDBServerResource.Get");
            scope.Start();
            try
            {
                var response = _oracleDBServerDBServersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDBServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
