// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="OracleDBServerResource"/> and their operations.
    /// Each <see cref="OracleDBServerResource"/> in the collection will belong to the same instance of <see cref="CloudExadataInfrastructureResource"/>.
    /// To get an <see cref="OracleDBServerCollection"/> instance call the GetOracleDBServers method from an instance of <see cref="CloudExadataInfrastructureResource"/>.
    /// </summary>
    public partial class OracleDBServerCollection : ArmCollection, IEnumerable<OracleDBServerResource>, IAsyncEnumerable<OracleDBServerResource>
    {
        private readonly ClientDiagnostics _oracleDBServerDBServersClientDiagnostics;
        private readonly DbServersRestOperations _oracleDBServerDBServersRestClient;

        /// <summary> Initializes a new instance of the <see cref="OracleDBServerCollection"/> class for mocking. </summary>
        protected OracleDBServerCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OracleDBServerCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal OracleDBServerCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _oracleDBServerDBServersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", OracleDBServerResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(OracleDBServerResource.ResourceType, out string oracleDBServerDBServersApiVersion);
            _oracleDBServerDBServersRestClient = new DbServersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, oracleDBServerDBServersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != CloudExadataInfrastructureResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, CloudExadataInfrastructureResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a DbServer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbserverocid"> DbServer OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbserverocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbserverocid"/> is null. </exception>
        public virtual async Task<Response<OracleDBServerResource>> GetAsync(string dbserverocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbserverocid, nameof(dbserverocid));

            using var scope = _oracleDBServerDBServersClientDiagnostics.CreateScope("OracleDBServerCollection.Get");
            scope.Start();
            try
            {
                var response = await _oracleDBServerDBServersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dbserverocid, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDBServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a DbServer
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbserverocid"> DbServer OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbserverocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbserverocid"/> is null. </exception>
        public virtual Response<OracleDBServerResource> Get(string dbserverocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbserverocid, nameof(dbserverocid));

            using var scope = _oracleDBServerDBServersClientDiagnostics.CreateScope("OracleDBServerCollection.Get");
            scope.Start();
            try
            {
                var response = _oracleDBServerDBServersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dbserverocid, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OracleDBServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List DbServer resources by CloudExadataInfrastructure
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_ListByCloudExadataInfrastructure</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OracleDBServerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OracleDBServerResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleDBServerDBServersRestClient.CreateListByCloudExadataInfrastructureRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleDBServerDBServersRestClient.CreateListByCloudExadataInfrastructureNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new OracleDBServerResource(Client, OracleDBServerData.DeserializeOracleDBServerData(e)), _oracleDBServerDBServersClientDiagnostics, Pipeline, "OracleDBServerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List DbServer resources by CloudExadataInfrastructure
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_ListByCloudExadataInfrastructure</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OracleDBServerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OracleDBServerResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _oracleDBServerDBServersRestClient.CreateListByCloudExadataInfrastructureRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _oracleDBServerDBServersRestClient.CreateListByCloudExadataInfrastructureNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new OracleDBServerResource(Client, OracleDBServerData.DeserializeOracleDBServerData(e)), _oracleDBServerDBServersClientDiagnostics, Pipeline, "OracleDBServerCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbserverocid"> DbServer OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbserverocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbserverocid"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string dbserverocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbserverocid, nameof(dbserverocid));

            using var scope = _oracleDBServerDBServersClientDiagnostics.CreateScope("OracleDBServerCollection.Exists");
            scope.Start();
            try
            {
                var response = await _oracleDBServerDBServersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dbserverocid, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbserverocid"> DbServer OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbserverocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbserverocid"/> is null. </exception>
        public virtual Response<bool> Exists(string dbserverocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbserverocid, nameof(dbserverocid));

            using var scope = _oracleDBServerDBServersClientDiagnostics.CreateScope("OracleDBServerCollection.Exists");
            scope.Start();
            try
            {
                var response = _oracleDBServerDBServersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dbserverocid, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbserverocid"> DbServer OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbserverocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbserverocid"/> is null. </exception>
        public virtual async Task<NullableResponse<OracleDBServerResource>> GetIfExistsAsync(string dbserverocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbserverocid, nameof(dbserverocid));

            using var scope = _oracleDBServerDBServersClientDiagnostics.CreateScope("OracleDBServerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _oracleDBServerDBServersRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dbserverocid, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<OracleDBServerResource>(response.GetRawResponse());
                return Response.FromValue(new OracleDBServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}/dbServers/{dbserverocid}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DbServers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OracleDBServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dbserverocid"> DbServer OCID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dbserverocid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dbserverocid"/> is null. </exception>
        public virtual NullableResponse<OracleDBServerResource> GetIfExists(string dbserverocid, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dbserverocid, nameof(dbserverocid));

            using var scope = _oracleDBServerDBServersClientDiagnostics.CreateScope("OracleDBServerCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _oracleDBServerDBServersRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dbserverocid, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<OracleDBServerResource>(response.GetRawResponse());
                return Response.FromValue(new OracleDBServerResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<OracleDBServerResource> IEnumerable<OracleDBServerResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<OracleDBServerResource> IAsyncEnumerable<OracleDBServerResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
