// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Generate type enum. </summary>
    public readonly partial struct WalletGenerateType : IEquatable<WalletGenerateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WalletGenerateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WalletGenerateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleValue = "Single";
        private const string AllValue = "All";

        /// <summary> Generate single. </summary>
        public static WalletGenerateType Single { get; } = new WalletGenerateType(SingleValue);
        /// <summary> Generate all. </summary>
        public static WalletGenerateType All { get; } = new WalletGenerateType(AllValue);
        /// <summary> Determines if two <see cref="WalletGenerateType"/> values are the same. </summary>
        public static bool operator ==(WalletGenerateType left, WalletGenerateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WalletGenerateType"/> values are not the same. </summary>
        public static bool operator !=(WalletGenerateType left, WalletGenerateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WalletGenerateType"/>. </summary>
        public static implicit operator WalletGenerateType(string value) => new WalletGenerateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WalletGenerateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WalletGenerateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
