// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> VirtualNetworkAddressLifecycleState enum. </summary>
    public readonly partial struct VirtualNetworkAddressLifecycleState : IEquatable<VirtualNetworkAddressLifecycleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkAddressLifecycleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualNetworkAddressLifecycleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string AvailableValue = "Available";
        private const string TerminatingValue = "Terminating";
        private const string TerminatedValue = "Terminated";
        private const string FailedValue = "Failed";

        /// <summary> Indicates that resource in Provisioning state. </summary>
        public static VirtualNetworkAddressLifecycleState Provisioning { get; } = new VirtualNetworkAddressLifecycleState(ProvisioningValue);
        /// <summary> Indicates that resource in Available state. </summary>
        public static VirtualNetworkAddressLifecycleState Available { get; } = new VirtualNetworkAddressLifecycleState(AvailableValue);
        /// <summary> Indicates that resource in Terminating state. </summary>
        public static VirtualNetworkAddressLifecycleState Terminating { get; } = new VirtualNetworkAddressLifecycleState(TerminatingValue);
        /// <summary> Indicates that resource in Terminated state. </summary>
        public static VirtualNetworkAddressLifecycleState Terminated { get; } = new VirtualNetworkAddressLifecycleState(TerminatedValue);
        /// <summary> Indicates that resource in Failed state. </summary>
        public static VirtualNetworkAddressLifecycleState Failed { get; } = new VirtualNetworkAddressLifecycleState(FailedValue);
        /// <summary> Determines if two <see cref="VirtualNetworkAddressLifecycleState"/> values are the same. </summary>
        public static bool operator ==(VirtualNetworkAddressLifecycleState left, VirtualNetworkAddressLifecycleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualNetworkAddressLifecycleState"/> values are not the same. </summary>
        public static bool operator !=(VirtualNetworkAddressLifecycleState left, VirtualNetworkAddressLifecycleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualNetworkAddressLifecycleState"/>. </summary>
        public static implicit operator VirtualNetworkAddressLifecycleState(string value) => new VirtualNetworkAddressLifecycleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualNetworkAddressLifecycleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualNetworkAddressLifecycleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
