// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Syntax format type enum. </summary>
    public readonly partial struct SyntaxFormatType : IEquatable<SyntaxFormatType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SyntaxFormatType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SyntaxFormatType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LongValue = "Long";
        private const string EzconnectValue = "Ezconnect";
        private const string EzconnectPlusValue = "Ezconnectplus";

        /// <summary> Long format. </summary>
        public static SyntaxFormatType Long { get; } = new SyntaxFormatType(LongValue);
        /// <summary> Ezconnect format. </summary>
        public static SyntaxFormatType Ezconnect { get; } = new SyntaxFormatType(EzconnectValue);
        /// <summary> Ezconnectplus format. </summary>
        public static SyntaxFormatType EzconnectPlus { get; } = new SyntaxFormatType(EzconnectPlusValue);
        /// <summary> Determines if two <see cref="SyntaxFormatType"/> values are the same. </summary>
        public static bool operator ==(SyntaxFormatType left, SyntaxFormatType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SyntaxFormatType"/> values are not the same. </summary>
        public static bool operator !=(SyntaxFormatType left, SyntaxFormatType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SyntaxFormatType"/>. </summary>
        public static implicit operator SyntaxFormatType(string value) => new SyntaxFormatType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SyntaxFormatType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SyntaxFormatType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
