// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class ScheduledOperationsTypeUpdate : IUtf8JsonSerializable, IJsonModel<ScheduledOperationsTypeUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScheduledOperationsTypeUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScheduledOperationsTypeUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledOperationsTypeUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScheduledOperationsTypeUpdate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DayOfWeek))
            {
                writer.WritePropertyName("dayOfWeek"u8);
                writer.WriteObjectValue(DayOfWeek, options);
            }
            if (Optional.IsDefined(AutoStartOn))
            {
                writer.WritePropertyName("scheduledStartTime"u8);
                writer.WriteStringValue(AutoStartOn.Value, "O");
            }
            if (Optional.IsDefined(AutoStopOn))
            {
                writer.WritePropertyName("scheduledStopTime"u8);
                writer.WriteStringValue(AutoStopOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScheduledOperationsTypeUpdate IJsonModel<ScheduledOperationsTypeUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledOperationsTypeUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScheduledOperationsTypeUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScheduledOperationsTypeUpdate(document.RootElement, options);
        }

        internal static ScheduledOperationsTypeUpdate DeserializeScheduledOperationsTypeUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DayOfWeekUpdate dayOfWeek = default;
            DateTimeOffset? scheduledStartTime = default;
            DateTimeOffset? scheduledStopTime = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dayOfWeek"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dayOfWeek = DayOfWeekUpdate.DeserializeDayOfWeekUpdate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("scheduledStartTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scheduledStartTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("scheduledStopTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scheduledStopTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScheduledOperationsTypeUpdate(dayOfWeek, scheduledStartTime, scheduledStopTime, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScheduledOperationsTypeUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledOperationsTypeUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScheduledOperationsTypeUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        ScheduledOperationsTypeUpdate IPersistableModel<ScheduledOperationsTypeUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledOperationsTypeUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScheduledOperationsTypeUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScheduledOperationsTypeUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScheduledOperationsTypeUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
