// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class ScheduledOperationsType : IUtf8JsonSerializable, IJsonModel<ScheduledOperationsType>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScheduledOperationsType>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScheduledOperationsType>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledOperationsType>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScheduledOperationsType)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("dayOfWeek"u8);
            writer.WriteObjectValue(DayOfWeek, options);
            if (Optional.IsDefined(AutoStartOn))
            {
                writer.WritePropertyName("scheduledStartTime"u8);
                writer.WriteStringValue(AutoStartOn.Value, "O");
            }
            if (Optional.IsDefined(AutoStopOn))
            {
                writer.WritePropertyName("scheduledStopTime"u8);
                writer.WriteStringValue(AutoStopOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScheduledOperationsType IJsonModel<ScheduledOperationsType>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledOperationsType>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScheduledOperationsType)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScheduledOperationsType(document.RootElement, options);
        }

        internal static ScheduledOperationsType DeserializeScheduledOperationsType(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            OracleDatabaseDayOfWeek dayOfWeek = default;
            DateTimeOffset? scheduledStartTime = default;
            DateTimeOffset? scheduledStopTime = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dayOfWeek"u8))
                {
                    dayOfWeek = OracleDatabaseDayOfWeek.DeserializeOracleDatabaseDayOfWeek(property.Value, options);
                    continue;
                }
                if (property.NameEquals("scheduledStartTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scheduledStartTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("scheduledStopTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scheduledStopTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScheduledOperationsType(dayOfWeek, scheduledStartTime, scheduledStopTime, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScheduledOperationsType>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledOperationsType>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScheduledOperationsType)} does not support writing '{options.Format}' format.");
            }
        }

        ScheduledOperationsType IPersistableModel<ScheduledOperationsType>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledOperationsType>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScheduledOperationsType(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScheduledOperationsType)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScheduledOperationsType>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
