// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Repeat cadence type enum. </summary>
    public readonly partial struct RepeatCadenceType : IEquatable<RepeatCadenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RepeatCadenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RepeatCadenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OneTimeValue = "OneTime";
        private const string WeeklyValue = "Weekly";
        private const string MonthlyValue = "Monthly";
        private const string YearlyValue = "Yearly";

        /// <summary> Repeat one time. </summary>
        public static RepeatCadenceType OneTime { get; } = new RepeatCadenceType(OneTimeValue);
        /// <summary> Repeat weekly. </summary>
        public static RepeatCadenceType Weekly { get; } = new RepeatCadenceType(WeeklyValue);
        /// <summary> Repeat monthly. </summary>
        public static RepeatCadenceType Monthly { get; } = new RepeatCadenceType(MonthlyValue);
        /// <summary> Repeat yearly. </summary>
        public static RepeatCadenceType Yearly { get; } = new RepeatCadenceType(YearlyValue);
        /// <summary> Determines if two <see cref="RepeatCadenceType"/> values are the same. </summary>
        public static bool operator ==(RepeatCadenceType left, RepeatCadenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RepeatCadenceType"/> values are not the same. </summary>
        public static bool operator !=(RepeatCadenceType left, RepeatCadenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RepeatCadenceType"/>. </summary>
        public static implicit operator RepeatCadenceType(string value) => new RepeatCadenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RepeatCadenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RepeatCadenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
