// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Refreshable status type enum. </summary>
    public readonly partial struct RefreshableStatusType : IEquatable<RefreshableStatusType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RefreshableStatusType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RefreshableStatusType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RefreshingValue = "Refreshing";
        private const string NotRefreshingValue = "NotRefreshing";

        /// <summary> Refreshing status. </summary>
        public static RefreshableStatusType Refreshing { get; } = new RefreshableStatusType(RefreshingValue);
        /// <summary> NotRefreshing status. </summary>
        public static RefreshableStatusType NotRefreshing { get; } = new RefreshableStatusType(NotRefreshingValue);
        /// <summary> Determines if two <see cref="RefreshableStatusType"/> values are the same. </summary>
        public static bool operator ==(RefreshableStatusType left, RefreshableStatusType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RefreshableStatusType"/> values are not the same. </summary>
        public static bool operator !=(RefreshableStatusType left, RefreshableStatusType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RefreshableStatusType"/>. </summary>
        public static implicit operator RefreshableStatusType(string value) => new RefreshableStatusType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RefreshableStatusType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RefreshableStatusType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
