// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Refreshable model type enum. </summary>
    public readonly partial struct RefreshableModelType : IEquatable<RefreshableModelType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RefreshableModelType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RefreshableModelType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomaticValue = "Automatic";
        private const string ManualValue = "Manual";

        /// <summary> Automatic refreshable model type. </summary>
        public static RefreshableModelType Automatic { get; } = new RefreshableModelType(AutomaticValue);
        /// <summary> Manual refreshable model type. </summary>
        public static RefreshableModelType Manual { get; } = new RefreshableModelType(ManualValue);
        /// <summary> Determines if two <see cref="RefreshableModelType"/> values are the same. </summary>
        public static bool operator ==(RefreshableModelType left, RefreshableModelType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RefreshableModelType"/> values are not the same. </summary>
        public static bool operator !=(RefreshableModelType left, RefreshableModelType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RefreshableModelType"/>. </summary>
        public static implicit operator RefreshableModelType(string value) => new RefreshableModelType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RefreshableModelType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RefreshableModelType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
