// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Intent enum. </summary>
    public readonly partial struct OracleSubscriptionUpdateIntent : IEquatable<OracleSubscriptionUpdateIntent>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OracleSubscriptionUpdateIntent"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OracleSubscriptionUpdateIntent(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RetainValue = "Retain";
        private const string ResetValue = "Reset";

        /// <summary> Retain intent. </summary>
        public static OracleSubscriptionUpdateIntent Retain { get; } = new OracleSubscriptionUpdateIntent(RetainValue);
        /// <summary> Reset intent. </summary>
        public static OracleSubscriptionUpdateIntent Reset { get; } = new OracleSubscriptionUpdateIntent(ResetValue);
        /// <summary> Determines if two <see cref="OracleSubscriptionUpdateIntent"/> values are the same. </summary>
        public static bool operator ==(OracleSubscriptionUpdateIntent left, OracleSubscriptionUpdateIntent right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OracleSubscriptionUpdateIntent"/> values are not the same. </summary>
        public static bool operator !=(OracleSubscriptionUpdateIntent left, OracleSubscriptionUpdateIntent right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OracleSubscriptionUpdateIntent"/>. </summary>
        public static implicit operator OracleSubscriptionUpdateIntent(string value) => new OracleSubscriptionUpdateIntent(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OracleSubscriptionUpdateIntent other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OracleSubscriptionUpdateIntent other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
