// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Oracle Subscription resource model. </summary>
    public partial class OracleSubscriptionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OracleSubscriptionProperties"/>. </summary>
        public OracleSubscriptionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OracleSubscriptionProperties"/>. </summary>
        /// <param name="provisioningState"> OracleSubscriptionProvisioningState provisioning state. </param>
        /// <param name="saasSubscriptionId"> SAAS subscription ID generated by Marketplace. </param>
        /// <param name="cloudAccountId"> Cloud Account Id. </param>
        /// <param name="cloudAccountState"> Cloud Account provisioning state. </param>
        /// <param name="termUnit"> Term Unit. P1Y, P3Y, etc, see Durations https://en.wikipedia.org/wiki/ISO_8601. </param>
        /// <param name="productCode"> Product code for the term unit. </param>
        /// <param name="intent"> Intent for the update operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OracleSubscriptionProperties(OracleSubscriptionProvisioningState? provisioningState, string saasSubscriptionId, ResourceIdentifier cloudAccountId, CloudAccountProvisioningState? cloudAccountState, string termUnit, string productCode, OracleSubscriptionUpdateIntent? intent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            SaasSubscriptionId = saasSubscriptionId;
            CloudAccountId = cloudAccountId;
            CloudAccountState = cloudAccountState;
            TermUnit = termUnit;
            ProductCode = productCode;
            Intent = intent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> OracleSubscriptionProvisioningState provisioning state. </summary>
        public OracleSubscriptionProvisioningState? ProvisioningState { get; }
        /// <summary> SAAS subscription ID generated by Marketplace. </summary>
        public string SaasSubscriptionId { get; }
        /// <summary> Cloud Account Id. </summary>
        public ResourceIdentifier CloudAccountId { get; }
        /// <summary> Cloud Account provisioning state. </summary>
        public CloudAccountProvisioningState? CloudAccountState { get; }
        /// <summary> Term Unit. P1Y, P3Y, etc, see Durations https://en.wikipedia.org/wiki/ISO_8601. </summary>
        public string TermUnit { get; set; }
        /// <summary> Product code for the term unit. </summary>
        public string ProductCode { get; set; }
        /// <summary> Intent for the update operation. </summary>
        public OracleSubscriptionUpdateIntent? Intent { get; set; }
    }
}
