// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class OracleSubscriptionProperties : IUtf8JsonSerializable, IJsonModel<OracleSubscriptionProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OracleSubscriptionProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OracleSubscriptionProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleSubscriptionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleSubscriptionProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(SaasSubscriptionId))
            {
                writer.WritePropertyName("saasSubscriptionId"u8);
                writer.WriteStringValue(SaasSubscriptionId);
            }
            if (options.Format != "W" && Optional.IsDefined(CloudAccountId))
            {
                writer.WritePropertyName("cloudAccountId"u8);
                writer.WriteStringValue(CloudAccountId);
            }
            if (options.Format != "W" && Optional.IsDefined(CloudAccountState))
            {
                writer.WritePropertyName("cloudAccountState"u8);
                writer.WriteStringValue(CloudAccountState.Value.ToString());
            }
            if (Optional.IsDefined(TermUnit))
            {
                writer.WritePropertyName("termUnit"u8);
                writer.WriteStringValue(TermUnit);
            }
            if (Optional.IsDefined(ProductCode))
            {
                writer.WritePropertyName("productCode"u8);
                writer.WriteStringValue(ProductCode);
            }
            if (Optional.IsDefined(Intent))
            {
                writer.WritePropertyName("intent"u8);
                writer.WriteStringValue(Intent.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OracleSubscriptionProperties IJsonModel<OracleSubscriptionProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleSubscriptionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleSubscriptionProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOracleSubscriptionProperties(document.RootElement, options);
        }

        internal static OracleSubscriptionProperties DeserializeOracleSubscriptionProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            OracleSubscriptionProvisioningState? provisioningState = default;
            string saasSubscriptionId = default;
            ResourceIdentifier cloudAccountId = default;
            CloudAccountProvisioningState? cloudAccountState = default;
            string termUnit = default;
            string productCode = default;
            OracleSubscriptionUpdateIntent? intent = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new OracleSubscriptionProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("saasSubscriptionId"u8))
                {
                    saasSubscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cloudAccountId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudAccountId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("cloudAccountState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudAccountState = new CloudAccountProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("termUnit"u8))
                {
                    termUnit = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("productCode"u8))
                {
                    productCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("intent"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    intent = new OracleSubscriptionUpdateIntent(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OracleSubscriptionProperties(
                provisioningState,
                saasSubscriptionId,
                cloudAccountId,
                cloudAccountState,
                termUnit,
                productCode,
                intent,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OracleSubscriptionProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleSubscriptionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OracleSubscriptionProperties)} does not support writing '{options.Format}' format.");
            }
        }

        OracleSubscriptionProperties IPersistableModel<OracleSubscriptionProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleSubscriptionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOracleSubscriptionProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OracleSubscriptionProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OracleSubscriptionProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
