// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> LicenseModel enum. </summary>
    public readonly partial struct OracleLicenseModel : IEquatable<OracleLicenseModel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OracleLicenseModel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OracleLicenseModel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LicenseIncludedValue = "LicenseIncluded";
        private const string BringYourOwnLicenseValue = "BringYourOwnLicense";

        /// <summary> License included. </summary>
        public static OracleLicenseModel LicenseIncluded { get; } = new OracleLicenseModel(LicenseIncludedValue);
        /// <summary> Bring Your Own License. </summary>
        public static OracleLicenseModel BringYourOwnLicense { get; } = new OracleLicenseModel(BringYourOwnLicenseValue);
        /// <summary> Determines if two <see cref="OracleLicenseModel"/> values are the same. </summary>
        public static bool operator ==(OracleLicenseModel left, OracleLicenseModel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OracleLicenseModel"/> values are not the same. </summary>
        public static bool operator !=(OracleLicenseModel left, OracleLicenseModel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OracleLicenseModel"/>. </summary>
        public static implicit operator OracleLicenseModel(string value) => new OracleLicenseModel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OracleLicenseModel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OracleLicenseModel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
