// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Zone type enum. </summary>
    public readonly partial struct OracleDnsPrivateZoneType : IEquatable<OracleDnsPrivateZoneType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OracleDnsPrivateZoneType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OracleDnsPrivateZoneType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "Primary";
        private const string SecondaryValue = "Secondary";

        /// <summary> Primary zone. </summary>
        public static OracleDnsPrivateZoneType Primary { get; } = new OracleDnsPrivateZoneType(PrimaryValue);
        /// <summary> Secondary zone. </summary>
        public static OracleDnsPrivateZoneType Secondary { get; } = new OracleDnsPrivateZoneType(SecondaryValue);
        /// <summary> Determines if two <see cref="OracleDnsPrivateZoneType"/> values are the same. </summary>
        public static bool operator ==(OracleDnsPrivateZoneType left, OracleDnsPrivateZoneType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OracleDnsPrivateZoneType"/> values are not the same. </summary>
        public static bool operator !=(OracleDnsPrivateZoneType left, OracleDnsPrivateZoneType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OracleDnsPrivateZoneType"/>. </summary>
        public static implicit operator OracleDnsPrivateZoneType(string value) => new OracleDnsPrivateZoneType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OracleDnsPrivateZoneType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OracleDnsPrivateZoneType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
