// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Zones resource model. </summary>
    public partial class OracleDnsPrivateZoneProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OracleDnsPrivateZoneProperties"/>. </summary>
        /// <param name="ocid"> The OCID of the Zone. </param>
        /// <param name="isProtected"> A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed. </param>
        /// <param name="self"> The canonical absolute URL of the resource. </param>
        /// <param name="serial"> The current serial of the zone. As seen in the zone's SOA record. </param>
        /// <param name="version"> Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived. </param>
        /// <param name="zoneType"> The type of the zone. Must be either PRIMARY or SECONDARY. SECONDARY is only supported for GLOBAL zones. </param>
        /// <param name="createdOn"> Zones timeCreated. </param>
        public OracleDnsPrivateZoneProperties(ResourceIdentifier ocid, bool isProtected, string self, int serial, string version, OracleDnsPrivateZoneType zoneType, DateTimeOffset createdOn)
        {
            Ocid = ocid;
            IsProtected = isProtected;
            Self = self;
            Serial = serial;
            Version = version;
            ZoneType = zoneType;
            CreatedOn = createdOn;
        }

        /// <summary> Initializes a new instance of <see cref="OracleDnsPrivateZoneProperties"/>. </summary>
        /// <param name="ocid"> The OCID of the Zone. </param>
        /// <param name="isProtected"> A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed. </param>
        /// <param name="lifecycleState"> Zones lifecycleState. </param>
        /// <param name="self"> The canonical absolute URL of the resource. </param>
        /// <param name="serial"> The current serial of the zone. As seen in the zone's SOA record. </param>
        /// <param name="version"> Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived. </param>
        /// <param name="viewId"> The OCID of the private view containing the zone. This value will be null for zones in the global DNS, which are publicly resolvable and not part of a private view. </param>
        /// <param name="zoneType"> The type of the zone. Must be either PRIMARY or SECONDARY. SECONDARY is only supported for GLOBAL zones. </param>
        /// <param name="createdOn"> Zones timeCreated. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OracleDnsPrivateZoneProperties(ResourceIdentifier ocid, bool isProtected, DnsPrivateZonesLifecycleState? lifecycleState, string self, int serial, string version, ResourceIdentifier viewId, OracleDnsPrivateZoneType zoneType, DateTimeOffset createdOn, OracleDatabaseResourceProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Ocid = ocid;
            IsProtected = isProtected;
            LifecycleState = lifecycleState;
            Self = self;
            Serial = serial;
            Version = version;
            ViewId = viewId;
            ZoneType = zoneType;
            CreatedOn = createdOn;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OracleDnsPrivateZoneProperties"/> for deserialization. </summary>
        internal OracleDnsPrivateZoneProperties()
        {
        }

        /// <summary> The OCID of the Zone. </summary>
        public ResourceIdentifier Ocid { get; }
        /// <summary> A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed. </summary>
        public bool IsProtected { get; }
        /// <summary> Zones lifecycleState. </summary>
        public DnsPrivateZonesLifecycleState? LifecycleState { get; }
        /// <summary> The canonical absolute URL of the resource. </summary>
        public string Self { get; }
        /// <summary> The current serial of the zone. As seen in the zone's SOA record. </summary>
        public int Serial { get; }
        /// <summary> Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived. </summary>
        public string Version { get; }
        /// <summary> The OCID of the private view containing the zone. This value will be null for zones in the global DNS, which are publicly resolvable and not part of a private view. </summary>
        public ResourceIdentifier ViewId { get; }
        /// <summary> The type of the zone. Must be either PRIMARY or SECONDARY. SECONDARY is only supported for GLOBAL zones. </summary>
        public OracleDnsPrivateZoneType ZoneType { get; }
        /// <summary> Zones timeCreated. </summary>
        public DateTimeOffset CreatedOn { get; }
        /// <summary> Azure resource provisioning state. </summary>
        public OracleDatabaseResourceProvisioningState? ProvisioningState { get; }
    }
}
