// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class OracleDnsPrivateZoneProperties : IUtf8JsonSerializable, IJsonModel<OracleDnsPrivateZoneProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OracleDnsPrivateZoneProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OracleDnsPrivateZoneProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDnsPrivateZoneProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleDnsPrivateZoneProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W")
            {
                writer.WritePropertyName("ocid"u8);
                writer.WriteStringValue(Ocid);
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("isProtected"u8);
                writer.WriteBooleanValue(IsProtected);
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleState))
            {
                writer.WritePropertyName("lifecycleState"u8);
                writer.WriteStringValue(LifecycleState.Value.ToString());
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("self"u8);
                writer.WriteStringValue(Self);
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("serial"u8);
                writer.WriteNumberValue(Serial);
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (options.Format != "W" && Optional.IsDefined(ViewId))
            {
                writer.WritePropertyName("viewId"u8);
                writer.WriteStringValue(ViewId);
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("zoneType"u8);
                writer.WriteStringValue(ZoneType.ToString());
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("timeCreated"u8);
                writer.WriteStringValue(CreatedOn, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OracleDnsPrivateZoneProperties IJsonModel<OracleDnsPrivateZoneProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDnsPrivateZoneProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleDnsPrivateZoneProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOracleDnsPrivateZoneProperties(document.RootElement, options);
        }

        internal static OracleDnsPrivateZoneProperties DeserializeOracleDnsPrivateZoneProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier ocid = default;
            bool isProtected = default;
            DnsPrivateZonesLifecycleState? lifecycleState = default;
            string self = default;
            int serial = default;
            string version = default;
            ResourceIdentifier viewId = default;
            OracleDnsPrivateZoneType zoneType = default;
            DateTimeOffset timeCreated = default;
            OracleDatabaseResourceProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ocid"u8))
                {
                    ocid = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isProtected"u8))
                {
                    isProtected = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("lifecycleState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lifecycleState = new DnsPrivateZonesLifecycleState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("self"u8))
                {
                    self = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serial"u8))
                {
                    serial = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("version"u8))
                {
                    version = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("viewId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    viewId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("zoneType"u8))
                {
                    zoneType = new OracleDnsPrivateZoneType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("timeCreated"u8))
                {
                    timeCreated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new OracleDatabaseResourceProvisioningState(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OracleDnsPrivateZoneProperties(
                ocid,
                isProtected,
                lifecycleState,
                self,
                serial,
                version,
                viewId,
                zoneType,
                timeCreated,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OracleDnsPrivateZoneProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDnsPrivateZoneProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OracleDnsPrivateZoneProperties)} does not support writing '{options.Format}' format.");
            }
        }

        OracleDnsPrivateZoneProperties IPersistableModel<OracleDnsPrivateZoneProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDnsPrivateZoneProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOracleDnsPrivateZoneProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OracleDnsPrivateZoneProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OracleDnsPrivateZoneProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
