// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class OracleDnsPrivateViewProperties : IUtf8JsonSerializable, IJsonModel<OracleDnsPrivateViewProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OracleDnsPrivateViewProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OracleDnsPrivateViewProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDnsPrivateViewProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleDnsPrivateViewProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W")
            {
                writer.WritePropertyName("ocid"u8);
                writer.WriteStringValue(Ocid);
            }
            if (options.Format != "W" && Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("isProtected"u8);
                writer.WriteBooleanValue(IsProtected);
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleState))
            {
                writer.WritePropertyName("lifecycleState"u8);
                writer.WriteStringValue(LifecycleState.Value.ToString());
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("self"u8);
                writer.WriteStringValue(Self);
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("timeCreated"u8);
                writer.WriteStringValue(CreatedOn, "O");
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("timeUpdated"u8);
                writer.WriteStringValue(UpdatedOn, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OracleDnsPrivateViewProperties IJsonModel<OracleDnsPrivateViewProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDnsPrivateViewProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleDnsPrivateViewProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOracleDnsPrivateViewProperties(document.RootElement, options);
        }

        internal static OracleDnsPrivateViewProperties DeserializeOracleDnsPrivateViewProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier ocid = default;
            string displayName = default;
            bool isProtected = default;
            DnsPrivateViewsLifecycleState? lifecycleState = default;
            string self = default;
            DateTimeOffset timeCreated = default;
            DateTimeOffset timeUpdated = default;
            OracleDatabaseResourceProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ocid"u8))
                {
                    ocid = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isProtected"u8))
                {
                    isProtected = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("lifecycleState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lifecycleState = new DnsPrivateViewsLifecycleState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("self"u8))
                {
                    self = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timeCreated"u8))
                {
                    timeCreated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("timeUpdated"u8))
                {
                    timeUpdated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new OracleDatabaseResourceProvisioningState(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OracleDnsPrivateViewProperties(
                ocid,
                displayName,
                isProtected,
                lifecycleState,
                self,
                timeCreated,
                timeUpdated,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OracleDnsPrivateViewProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDnsPrivateViewProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OracleDnsPrivateViewProperties)} does not support writing '{options.Format}' format.");
            }
        }

        OracleDnsPrivateViewProperties IPersistableModel<OracleDnsPrivateViewProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDnsPrivateViewProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOracleDnsPrivateViewProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OracleDnsPrivateViewProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OracleDnsPrivateViewProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
