// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Azure Resource Provisioning State enum. </summary>
    public readonly partial struct OracleDatabaseProvisioningState : IEquatable<OracleDatabaseProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OracleDatabaseProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OracleDatabaseProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";

        /// <summary> Resource has been created. </summary>
        public static OracleDatabaseProvisioningState Succeeded { get; } = new OracleDatabaseProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static OracleDatabaseProvisioningState Failed { get; } = new OracleDatabaseProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static OracleDatabaseProvisioningState Canceled { get; } = new OracleDatabaseProvisioningState(CanceledValue);
        /// <summary> Indicates that resource in Provisioning state. </summary>
        public static OracleDatabaseProvisioningState Provisioning { get; } = new OracleDatabaseProvisioningState(ProvisioningValue);
        /// <summary> Determines if two <see cref="OracleDatabaseProvisioningState"/> values are the same. </summary>
        public static bool operator ==(OracleDatabaseProvisioningState left, OracleDatabaseProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OracleDatabaseProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(OracleDatabaseProvisioningState left, OracleDatabaseProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OracleDatabaseProvisioningState"/>. </summary>
        public static implicit operator OracleDatabaseProvisioningState(string value) => new OracleDatabaseProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OracleDatabaseProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OracleDatabaseProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
