// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> MaintenanceWindow resource properties. </summary>
    public partial class OracleDatabaseMaintenanceWindow
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OracleDatabaseMaintenanceWindow"/>. </summary>
        public OracleDatabaseMaintenanceWindow()
        {
            Months = new ChangeTrackingList<MaintenanceMonth>();
            WeeksOfMonth = new ChangeTrackingList<int>();
            DaysOfWeek = new ChangeTrackingList<OracleDatabaseDayOfWeek>();
            HoursOfDay = new ChangeTrackingList<int>();
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabaseMaintenanceWindow"/>. </summary>
        /// <param name="preference"> The maintenance window scheduling preference. </param>
        /// <param name="months"> Months during the year when maintenance should be performed. </param>
        /// <param name="weeksOfMonth"> Weeks during the month when maintenance should be performed. Weeks start on the 1st, 8th, 15th, and 22nd days of the month, and have a duration of 7 days. Weeks start and end based on calendar dates, not days of the week. For example, to allow maintenance during the 2nd week of the month (from the 8th day to the 14th day of the month), use the value 2. Maintenance cannot be scheduled for the fifth week of months that contain more than 28 days. Note that this parameter works in conjunction with the  daysOfWeek and hoursOfDay parameters to allow you to specify specific days of the week and hours that maintenance will be performed. </param>
        /// <param name="daysOfWeek"> Days during the week when maintenance should be performed. </param>
        /// <param name="hoursOfDay"> The window of hours during the day when maintenance should be performed. The window is a 4 hour slot. Valid values are - 0 - represents time slot 0:00 - 3:59 UTC - 4 - represents time slot 4:00 - 7:59 UTC - 8 - represents time slot 8:00 - 11:59 UTC - 12 - represents time slot 12:00 - 15:59 UTC - 16 - represents time slot 16:00 - 19:59 UTC - 20 - represents time slot 20:00 - 23:59 UTC. </param>
        /// <param name="leadTimeInWeeks"> Lead time window allows user to set a lead time to prepare for a down time. The lead time is in weeks and valid value is between 1 to 4. </param>
        /// <param name="patchingMode"> Cloud Exadata infrastructure node patching method. </param>
        /// <param name="customActionTimeoutInMins"> Determines the amount of time the system will wait before the start of each database server patching operation. Custom action timeout is in minutes and valid value is between 15 to 120 (inclusive). </param>
        /// <param name="isCustomActionTimeoutEnabled"> If true, enables the configuration of a custom action timeout (waiting period) between database server patching operations. </param>
        /// <param name="isMonthlyPatchingEnabled"> is Monthly Patching Enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OracleDatabaseMaintenanceWindow(MaintenancePreference? preference, IList<MaintenanceMonth> months, IList<int> weeksOfMonth, IList<OracleDatabaseDayOfWeek> daysOfWeek, IList<int> hoursOfDay, int? leadTimeInWeeks, MaintenancePatchingMode? patchingMode, int? customActionTimeoutInMins, bool? isCustomActionTimeoutEnabled, bool? isMonthlyPatchingEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Preference = preference;
            Months = months;
            WeeksOfMonth = weeksOfMonth;
            DaysOfWeek = daysOfWeek;
            HoursOfDay = hoursOfDay;
            LeadTimeInWeeks = leadTimeInWeeks;
            PatchingMode = patchingMode;
            CustomActionTimeoutInMins = customActionTimeoutInMins;
            IsCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
            IsMonthlyPatchingEnabled = isMonthlyPatchingEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The maintenance window scheduling preference. </summary>
        public MaintenancePreference? Preference { get; set; }
        /// <summary> Months during the year when maintenance should be performed. </summary>
        public IList<MaintenanceMonth> Months { get; }
        /// <summary> Weeks during the month when maintenance should be performed. Weeks start on the 1st, 8th, 15th, and 22nd days of the month, and have a duration of 7 days. Weeks start and end based on calendar dates, not days of the week. For example, to allow maintenance during the 2nd week of the month (from the 8th day to the 14th day of the month), use the value 2. Maintenance cannot be scheduled for the fifth week of months that contain more than 28 days. Note that this parameter works in conjunction with the  daysOfWeek and hoursOfDay parameters to allow you to specify specific days of the week and hours that maintenance will be performed. </summary>
        public IList<int> WeeksOfMonth { get; }
        /// <summary> Days during the week when maintenance should be performed. </summary>
        public IList<OracleDatabaseDayOfWeek> DaysOfWeek { get; }
        /// <summary> The window of hours during the day when maintenance should be performed. The window is a 4 hour slot. Valid values are - 0 - represents time slot 0:00 - 3:59 UTC - 4 - represents time slot 4:00 - 7:59 UTC - 8 - represents time slot 8:00 - 11:59 UTC - 12 - represents time slot 12:00 - 15:59 UTC - 16 - represents time slot 16:00 - 19:59 UTC - 20 - represents time slot 20:00 - 23:59 UTC. </summary>
        public IList<int> HoursOfDay { get; }
        /// <summary> Lead time window allows user to set a lead time to prepare for a down time. The lead time is in weeks and valid value is between 1 to 4. </summary>
        public int? LeadTimeInWeeks { get; set; }
        /// <summary> Cloud Exadata infrastructure node patching method. </summary>
        public MaintenancePatchingMode? PatchingMode { get; set; }
        /// <summary> Determines the amount of time the system will wait before the start of each database server patching operation. Custom action timeout is in minutes and valid value is between 15 to 120 (inclusive). </summary>
        public int? CustomActionTimeoutInMins { get; set; }
        /// <summary> If true, enables the configuration of a custom action timeout (waiting period) between database server patching operations. </summary>
        public bool? IsCustomActionTimeoutEnabled { get; set; }
        /// <summary> is Monthly Patching Enabled. </summary>
        public bool? IsMonthlyPatchingEnabled { get; set; }
    }
}
