// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class OracleDatabaseMaintenanceWindow : IUtf8JsonSerializable, IJsonModel<OracleDatabaseMaintenanceWindow>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OracleDatabaseMaintenanceWindow>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OracleDatabaseMaintenanceWindow>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDatabaseMaintenanceWindow>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleDatabaseMaintenanceWindow)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Preference))
            {
                writer.WritePropertyName("preference"u8);
                writer.WriteStringValue(Preference.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Months))
            {
                writer.WritePropertyName("months"u8);
                writer.WriteStartArray();
                foreach (var item in Months)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(WeeksOfMonth))
            {
                writer.WritePropertyName("weeksOfMonth"u8);
                writer.WriteStartArray();
                foreach (var item in WeeksOfMonth)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(DaysOfWeek))
            {
                writer.WritePropertyName("daysOfWeek"u8);
                writer.WriteStartArray();
                foreach (var item in DaysOfWeek)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(HoursOfDay))
            {
                writer.WritePropertyName("hoursOfDay"u8);
                writer.WriteStartArray();
                foreach (var item in HoursOfDay)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(LeadTimeInWeeks))
            {
                writer.WritePropertyName("leadTimeInWeeks"u8);
                writer.WriteNumberValue(LeadTimeInWeeks.Value);
            }
            if (Optional.IsDefined(PatchingMode))
            {
                writer.WritePropertyName("patchingMode"u8);
                writer.WriteStringValue(PatchingMode.Value.ToString());
            }
            if (Optional.IsDefined(CustomActionTimeoutInMins))
            {
                writer.WritePropertyName("customActionTimeoutInMins"u8);
                writer.WriteNumberValue(CustomActionTimeoutInMins.Value);
            }
            if (Optional.IsDefined(IsCustomActionTimeoutEnabled))
            {
                writer.WritePropertyName("isCustomActionTimeoutEnabled"u8);
                writer.WriteBooleanValue(IsCustomActionTimeoutEnabled.Value);
            }
            if (Optional.IsDefined(IsMonthlyPatchingEnabled))
            {
                writer.WritePropertyName("isMonthlyPatchingEnabled"u8);
                writer.WriteBooleanValue(IsMonthlyPatchingEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OracleDatabaseMaintenanceWindow IJsonModel<OracleDatabaseMaintenanceWindow>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDatabaseMaintenanceWindow>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleDatabaseMaintenanceWindow)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOracleDatabaseMaintenanceWindow(document.RootElement, options);
        }

        internal static OracleDatabaseMaintenanceWindow DeserializeOracleDatabaseMaintenanceWindow(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MaintenancePreference? preference = default;
            IList<MaintenanceMonth> months = default;
            IList<int> weeksOfMonth = default;
            IList<OracleDatabaseDayOfWeek> daysOfWeek = default;
            IList<int> hoursOfDay = default;
            int? leadTimeInWeeks = default;
            MaintenancePatchingMode? patchingMode = default;
            int? customActionTimeoutInMins = default;
            bool? isCustomActionTimeoutEnabled = default;
            bool? isMonthlyPatchingEnabled = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("preference"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    preference = new MaintenancePreference(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("months"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MaintenanceMonth> array = new List<MaintenanceMonth>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MaintenanceMonth.DeserializeMaintenanceMonth(item, options));
                    }
                    months = array;
                    continue;
                }
                if (property.NameEquals("weeksOfMonth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<int> array = new List<int>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetInt32());
                    }
                    weeksOfMonth = array;
                    continue;
                }
                if (property.NameEquals("daysOfWeek"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<OracleDatabaseDayOfWeek> array = new List<OracleDatabaseDayOfWeek>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(OracleDatabaseDayOfWeek.DeserializeOracleDatabaseDayOfWeek(item, options));
                    }
                    daysOfWeek = array;
                    continue;
                }
                if (property.NameEquals("hoursOfDay"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<int> array = new List<int>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetInt32());
                    }
                    hoursOfDay = array;
                    continue;
                }
                if (property.NameEquals("leadTimeInWeeks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    leadTimeInWeeks = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("patchingMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    patchingMode = new MaintenancePatchingMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("customActionTimeoutInMins"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    customActionTimeoutInMins = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("isCustomActionTimeoutEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isCustomActionTimeoutEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isMonthlyPatchingEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isMonthlyPatchingEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OracleDatabaseMaintenanceWindow(
                preference,
                months ?? new ChangeTrackingList<MaintenanceMonth>(),
                weeksOfMonth ?? new ChangeTrackingList<int>(),
                daysOfWeek ?? new ChangeTrackingList<OracleDatabaseDayOfWeek>(),
                hoursOfDay ?? new ChangeTrackingList<int>(),
                leadTimeInWeeks,
                patchingMode,
                customActionTimeoutInMins,
                isCustomActionTimeoutEnabled,
                isMonthlyPatchingEnabled,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OracleDatabaseMaintenanceWindow>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDatabaseMaintenanceWindow>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OracleDatabaseMaintenanceWindow)} does not support writing '{options.Format}' format.");
            }
        }

        OracleDatabaseMaintenanceWindow IPersistableModel<OracleDatabaseMaintenanceWindow>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDatabaseMaintenanceWindow>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOracleDatabaseMaintenanceWindow(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OracleDatabaseMaintenanceWindow)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OracleDatabaseMaintenanceWindow>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
