// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Database edition type enum. </summary>
    public readonly partial struct OracleDatabaseEditionType : IEquatable<OracleDatabaseEditionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OracleDatabaseEditionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OracleDatabaseEditionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardEditionValue = "StandardEdition";
        private const string EnterpriseEditionValue = "EnterpriseEdition";

        /// <summary> Standard edition. </summary>
        public static OracleDatabaseEditionType StandardEdition { get; } = new OracleDatabaseEditionType(StandardEditionValue);
        /// <summary> Enterprise edition. </summary>
        public static OracleDatabaseEditionType EnterpriseEdition { get; } = new OracleDatabaseEditionType(EnterpriseEditionValue);
        /// <summary> Determines if two <see cref="OracleDatabaseEditionType"/> values are the same. </summary>
        public static bool operator ==(OracleDatabaseEditionType left, OracleDatabaseEditionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OracleDatabaseEditionType"/> values are not the same. </summary>
        public static bool operator !=(OracleDatabaseEditionType left, OracleDatabaseEditionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OracleDatabaseEditionType"/>. </summary>
        public static implicit operator OracleDatabaseEditionType(string value) => new OracleDatabaseEditionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OracleDatabaseEditionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OracleDatabaseEditionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
