// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DayOfWeekName enum. </summary>
    public readonly partial struct OracleDatabaseDayOfWeekName : IEquatable<OracleDatabaseDayOfWeekName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OracleDatabaseDayOfWeekName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OracleDatabaseDayOfWeekName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MondayValue = "Monday";
        private const string TuesdayValue = "Tuesday";
        private const string WednesdayValue = "Wednesday";
        private const string ThursdayValue = "Thursday";
        private const string FridayValue = "Friday";
        private const string SaturdayValue = "Saturday";
        private const string SundayValue = "Sunday";

        /// <summary> Monday value. </summary>
        public static OracleDatabaseDayOfWeekName Monday { get; } = new OracleDatabaseDayOfWeekName(MondayValue);
        /// <summary> Tuesday value. </summary>
        public static OracleDatabaseDayOfWeekName Tuesday { get; } = new OracleDatabaseDayOfWeekName(TuesdayValue);
        /// <summary> Wednesday value. </summary>
        public static OracleDatabaseDayOfWeekName Wednesday { get; } = new OracleDatabaseDayOfWeekName(WednesdayValue);
        /// <summary> Thursday value. </summary>
        public static OracleDatabaseDayOfWeekName Thursday { get; } = new OracleDatabaseDayOfWeekName(ThursdayValue);
        /// <summary> Friday value. </summary>
        public static OracleDatabaseDayOfWeekName Friday { get; } = new OracleDatabaseDayOfWeekName(FridayValue);
        /// <summary> Saturday value. </summary>
        public static OracleDatabaseDayOfWeekName Saturday { get; } = new OracleDatabaseDayOfWeekName(SaturdayValue);
        /// <summary> Sunday value. </summary>
        public static OracleDatabaseDayOfWeekName Sunday { get; } = new OracleDatabaseDayOfWeekName(SundayValue);
        /// <summary> Determines if two <see cref="OracleDatabaseDayOfWeekName"/> values are the same. </summary>
        public static bool operator ==(OracleDatabaseDayOfWeekName left, OracleDatabaseDayOfWeekName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OracleDatabaseDayOfWeekName"/> values are not the same. </summary>
        public static bool operator !=(OracleDatabaseDayOfWeekName left, OracleDatabaseDayOfWeekName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OracleDatabaseDayOfWeekName"/>. </summary>
        public static implicit operator OracleDatabaseDayOfWeekName(string value) => new OracleDatabaseDayOfWeekName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OracleDatabaseDayOfWeekName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OracleDatabaseDayOfWeekName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
