// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Database type enum. </summary>
    internal readonly partial struct OracleDataBaseType : IEquatable<OracleDataBaseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OracleDataBaseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OracleDataBaseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegularValue = "Regular";
        private const string CloneValue = "Clone";

        /// <summary> Regular DB. </summary>
        public static OracleDataBaseType Regular { get; } = new OracleDataBaseType(RegularValue);
        /// <summary> Clone DB. </summary>
        public static OracleDataBaseType Clone { get; } = new OracleDataBaseType(CloneValue);
        /// <summary> Determines if two <see cref="OracleDataBaseType"/> values are the same. </summary>
        public static bool operator ==(OracleDataBaseType left, OracleDataBaseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OracleDataBaseType"/> values are not the same. </summary>
        public static bool operator !=(OracleDataBaseType left, OracleDataBaseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OracleDataBaseType"/>. </summary>
        public static implicit operator OracleDataBaseType(string value) => new OracleDataBaseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OracleDataBaseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OracleDataBaseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
